#******************************************************************************
#
#       Copyright (C)1998,1999 by Eric Sunshine <sunshine@sunshineco.com>
#
# The contents of this file are copyrighted by Eric Sunshine.  You may use
# this file in your own projects provided that this copyright notice is
# retained verbatim.
#
#******************************************************************************
#------------------------------------------------------------------------------
# platform.make                                       (1999-06-09, version 1.1)
#
#       A cross-platform compatibility makefile which allows a project to be
#       built for both MacOS/X Server and OpenStep without maintaining
#       distinct PB.project files and Makefiles for each platform.
#
#       Prior to MacOS/X Server, system-supplied makefiles resided in a
#       constant location, in this case $(NEXT_ROOT)/NextDeveloper/Makefiles.
#       As of MacOS/X Server, however, the directory structure changed, so
#       that on Mach, makefiles now reside in /System/Developer/Makefiles, and
#       on Windows they reside in $(NEXT_ROOT)/Developer/Makefiles.
#
#       Apple hacked GNU's "make" utility on MacOS/X Server so that it
#       automatically defines the variable MAKEFILEPATH, which on Mach
#       defaults to /System/Developer/Makefiles, and on Microsoft Windows
#       defaults to $(NEXT_ROOT)/Developer/Makefiles.  In this manner, they
#       are able to refer to the system makefile directory without having to
#       hardcode the path into the local makefile as they did prior to MacOS/X
#       Server.
#
#       However, Apple's hack does not help the developer who must still
#       support earlier platforms which use the old directory structure, nor
#       did Apple provide a backward compatibility solution.  Consequently,
#       the developer is forced to maintain two sets of PB.project files and
#       Makefiles; one for OpenStep 4.x, and one for MacOS/X Server and later.
#
#       This file (platform.make) bridges the gap between the old directory
#       structure and the new by forcefully inserting itself into the make
#       process at the earliest possible time and adjusting the makefile path
#       dynamically to match either the old or the new directory structure.
#
#       To insert this file into the make process, follow these steps:
#
#       a) If the project is currently open in ProjectBuilder.app, close it.
#       b) Open the project's top-level PB.project file in a text editor.
#       c) Find the line which defines MAKEFILEDIR.  Its definition will be
#          either $(NEXT_ROOT)/NextDeveloper/Makefiles/pb_makefiles or
#          $(MAKEFILEPATH)/pb_makefiles depending upon whether it was
#          generated by OpenStep 4.x or MacOS/X Server.
#       d) Change the value of MAKEFILEDIR to "." (a single quoted period).
#       e) Open the project's top-level Makefile in a text editor.
#       f) Find the line which defines MAKEFILEDIR.
#       g) Change the value of MAKEFILEDIR to . (a single period).
#       h) Place this file (platform.make) in the project's main directory.
#
#       The variable MAKEFILEDIR is normally used to locate the system makefile
#       directory from which platform.make is loaded as the very beginning of
#       the build process.  By changing the value of MAKEFILEDIR to ".", this
#       replacement platform.make gets loaded instead.
#
#       Once in control, this file determines the correct makefile path
#       dynamically, either $(NEXT_ROOT)/NextDeveloper/Makefiles/pb_makefiles
#       or $(MAKEFILEPATH)/pb_makefiles and sets it as the value of MAKEFILEDIR
#       so that later references to MAKEFILEDIR use the actual system
#       makefiles.  Finally, the real system platform.make is loaded, and
#       control returns to the caller.
#
#       To further facilitate cross-platform development, this file also
#       defines the following variables for pre-MacOS/X Server platforms which
#       are normally only defined for MacOS/X Server and later platforms.
#       These variables are typically used by "install" targets where the
#       installation location may vary from platform to platform.
#
#       MAKEFILEPATH            Path to system makefiles
#       USER_APPS_DIR           $(HOME)/Apps [vs. $(HOME)/Applications on OS/X]
#       USER_LIBRARY_DIR        $(HOME)/Library
#       LOCAL_APPS_DIR          /LocalApps [Mach] or /Local/Apps [Windows]
#       LOCAL_LIBRARY_DIR       /LocalLibrary or /Local/Library
#       LOCAL_DEVELOPER_DIR     /LocalDeveloper or /Local/Developer
#
# Please send comments to Eric Sunshine <sunshine@sunshineco.com>
# MIME, NeXT, and ASCII mail accepted.
#------------------------------------------------------------------------------

ifndef MAKEFILEPATH
MAKEFILEPATH=$(NEXT_ROOT)/NextDeveloper/Makefiles
endif
MAKEFILEDIR=$(MAKEFILEPATH)/pb_makefiles

include $(MAKEFILEDIR)/platform.make

ifeq "NEXTSTEP" "$(OS)"

ifndef USER_APPS_DIR
export USER_APPS_DIR=$(HOME)/Apps
endif
ifndef USER_LIBRARY_DIR
export USER_LIBRARY_DIR=$(HOME)/Library
endif
ifndef LOCAL_APPS_DIR
export LOCAL_APPS_DIR=/LocalApps
endif
ifndef LOCAL_LIBRARY_DIR
export LOCAL_LIBRARY_DIR=/LocalLibrary
endif
ifndef LOCAL_DEVELOPER_DIR
export LOCAL_DEVELOPER_DIR=/LocalDeveloper
endif

else # Windows and PDO platforms

ifndef USER_APPS_DIR
export USER_APPS_DIR=$(HOME)/Apps
endif
ifndef USER_LIBRARY_DIR
export USER_LIBRARY_DIR=$(HOME)/Library
endif
ifndef LOCAL_APPS_DIR
export LOCAL_APPS_DIR=$(NEXT_ROOT)/Local/Apps
endif
ifndef LOCAL_LIBRARY_DIR
export LOCAL_LIBRARY_DIR=$(NEXT_ROOT)/Local/Library
endif
ifndef LOCAL_DEVELOPER_DIR
export LOCAL_DEVELOPER_DIR=$(NEXT_ROOT)/Local/Developer
endif

endif
