//-----------------------------------------------------------------------------
// SokoWindow.m
//
//	NSWindow and NSPanel subclasses for SokoSave.
//
// Copyright (c), 1998,2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoWindow.m,v 1.1 2001/12/23 16:05:14 sunshine Exp $
// $Log: SokoWindow.m,v $
// Revision 1.1  2001/12/23 16:05:14  sunshine
// v15
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//
// -*- On Windows, now ensures that the puzzle view does not get occluded by
//     the menu if the user changes display preferences via the Control
//     Panel.  For instance, the user might assign a larger font to the menu,
//     or the menu might wrap, thus occluding the puzzle view.  This is
//     accomplished by catching the WM_SETTINGCHANGED message from Windows
//     and adjusting the window frame as needed.
//
// -*- Worked around an AppKit bug on Windows which appeared in this release
//     when small versions of the icons were incorporated into the ICO files.
//     The AppKit failed to use these small icons in the window title bars.
//     Instead, it used a scrunched version of the large icon, which was
//     quite ugly.
//
// -*- Worked around an AppKit bug on Windows in which the Preferences panel
//     would suddenly appear on the "Window" menu when -setDocumentEdited:
//     was invoked even though panels are not supposed to appear on this
//     menu.  This problem was further compounded by the fact that the menu
//     item would remain dangling on the menu even after the Preferences
//     panel was closed.
//
// -*- Worked around an AppKit bug on Windows 9x which caused the window size
//     of SokoBoard windows to become completely corrupt when miniaturized.
//     This bug only seems to affect non-resizeable windows (such as
//     SokoBoard) and only occurs on Windows 9x.  (Windows NT and 2000 are
//     not afflicted.)
//
//-----------------------------------------------------------------------------
#import "SokoWindow.h"
#import <Foundation/NSString.h>

NSString* const SokoWindowMetricsChangedNotification =
    @"SokoWindowMetricsChangedNotification";

//=============================================================================
// SokoWindow
//=============================================================================
@implementation SokoWindow
#if !defined(SOKO_CUSTOM_WINDOW_FINALIZE)
- (void)finalize {}
#endif
@end


//=============================================================================
// SokoPanel
//=============================================================================
@implementation SokoPanel
#if !defined(SOKO_PANEL_DOC_EDITED_BROKEN)
- (void)setDocumentEdited:(BOOL)flag { [super setDocumentEdited:flag]; }
- (BOOL)isDocumentEdited { return [super isDocumentEdited]; }
#endif
@end
