#ifndef SokoURL_h
#define SokoURL_h
//-----------------------------------------------------------------------------
// SokoURL.h
//
//	Subclass of NSTextField which displays and dispatches a URL.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL.h,v 1.1 2001/12/23 15:29:56 sunshine Exp $
// $Log: SokoURL.h,v $
// Revision 1.1  2001/12/23 15:29:56  sunshine
// v15
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  On MacOS/X, it knows how to
//     dispatch any URL understood by -[NSWorkspace openURL:].  On Windows,
//     it knows how to dispatch any URL understood by ShellExecute().  On
//     MacOS/X Server 1.0 (Rhapsody), OpenStep/Mach, and NextStep, it knows
//     how to dispatch mailto: URLs directly; all others are handed off to
//     OmniWeb's "Open URL" service.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
//-----------------------------------------------------------------------------
#import <AppKit/NSTextField.h>

@interface SokoURL : NSTextField
    {
    NSString* url;
    BOOL urlValid;
    NSTrackingRectTag trackTag;
    BOOL mouseInside;
    BOOL trackingMouse;
    }

- (id)initWithFrame:(NSRect)r;
- (void)dealloc;
- (void)setStringValue:(NSString*)s;
- (void)setStringValue:(NSString*)s url:(NSString*)url;
- (void)setUrl:(NSString*)url;
- (NSString*)url;
- (BOOL)dispatchUrl;
- (void)startTracking;
- (void)stopTracking;

@end

#endif // SokoURL_h
