//-----------------------------------------------------------------------------
// SokoURL-windows.m
//
//	URL dispatcher for Microsoft Windows.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL-windows.m,v 1.1 2001/12/23 15:30:02 sunshine Exp $
// $Log: SokoURL-windows.m,v $
// Revision 1.1  2001/12/23 15:30:02  sunshine
// v15
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  On MacOS/X, it knows how to
//     dispatch any URL understood by -[NSWorkspace openURL:].  On Windows,
//     it knows how to dispatch any URL understood by ShellExecute().  On
//     MacOS/X Server 1.0 (Rhapsody), OpenStep/Mach, and NextStep, it knows
//     how to dispatch mailto: URLs directly; all others are handed off to
//     OmniWeb's "Open URL" service.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
//-----------------------------------------------------------------------------
#import <AppKit/NSApplication.h>
#import <Foundation/NSString.h>
#import <windows.h>
#import <shellapi.h>

#define SHELL_EXECUTE_OK(X) (((int)X) >= 32)

//-----------------------------------------------------------------------------
// soko_dispatch_url
//-----------------------------------------------------------------------------
BOOL soko_dispatch_url( NSString* url )
    {
    HINSTANCE rc = ShellExecute( (HWND)[NSApp applicationHandle], "open",
	[url lossyCString], 0, 0, SW_SHOW );
    return SHELL_EXECUTE_OK(rc);
    }
