//-----------------------------------------------------------------------------
// SokoURL-rhapsody.m
//
//	URL dispatcher for MacOS/X Server 1.0 Mach (Rhapsody).
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL-rhapsody.m,v 1.1 2001/12/23 15:30:22 sunshine Exp $
// $Log: SokoURL-rhapsody.m,v $
// Revision 1.1  2001/12/23 15:30:22  sunshine
// v15
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  On MacOS/X, it knows how to
//     dispatch any URL understood by -[NSWorkspace openURL:].  On Windows,
//     it knows how to dispatch any URL understood by ShellExecute().  On
//     MacOS/X Server 1.0 (Rhapsody), OpenStep/Mach, and NextStep, it knows
//     how to dispatch mailto: URLs directly; all others are handed off to
//     OmniWeb's "Open URL" service.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
//-----------------------------------------------------------------------------
#import <AppKit/NSApplication.h>
#import <AppKit/NSPasteboard.h>
#import <AppKit/NSPanel.h>

#define SOKO_URL_SERVICE @"OmniWeb/Open URL"
#define SOKO_MAIL_SERVICE @"MailViewer/Mail To"

//=============================================================================
// soko_dispatch_url
//	Figure out the correct mechanism for dispatching a particular URL
//	and invoke that mechanism.
//
// *SERVICE*
//	There is an apparent bug with the implementaiton of NSPerformService()
//	on MacOS/X Server 1.0 (Rhapsody) where it corrupts the incoming
//	pasteboard.  The symptom is that, after the first invocation of
//	NSPerformService(), all subsequent invocations of -declareTypes:owner:
//	& -setString:forType: cause an exception to be thrown.  This problem
//	only occurs if NSPerformService() is invoked.  If it is not invoked,
//	then the pasteboard behaves normally and can be re-used any number of
//	times, as documented, by sending -declareTypes:owner: &
//	setString:forType:.  To work around this problem, it is necessary to
//	create a brand new pasteboard for each invocation of
//	NSPerformService(), so as to avoid re-using the corrupted pasteboard.
//	Note, also, that the program to which the service request is sent may
//	not be able to handle the request immediately, so we can not destroy
//	the used-pasteboard right away, since it must still exist at the time
//	when the receiving application finally gets around to handling the
//	service request.  Therefore, we only destroy the pasteboard the next
//	time we are asked to dispatch a URL.
//=============================================================================
BOOL soko_dispatch_url( NSString* url )
    {
    BOOL ok = NO;
    NSString* service = SOKO_URL_SERVICE;
    NSString* data = url;
    if ([[url lowercaseString] hasPrefix:@"mailto:"])
	{
	service = SOKO_MAIL_SERVICE;
	data = [url substringFromIndex:[@"mailto:" length]];
	}
    NS_DURING
	static NSPasteboard* pb = 0;
	if (pb != 0)
	    {
	    [pb releaseGlobally];
	    [pb release];
	    }
	pb = [[NSPasteboard pasteboardWithUniqueName] retain];
	[pb declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:0];
	[pb setString:data forType:NSStringPboardType];
	ok = NSPerformService( service, pb );
    NS_HANDLER
	NSRunCriticalAlertPanel( @"SokoSave",
	    @"Communication error while dispatching URL: %@", 0,0,0, url );
    NS_ENDHANDLER
    return ok;
    }
