#ifndef SokoScores_h
#define SokoScores_h
//-----------------------------------------------------------------------------
// SokoScores.h
//
//	"Top-Scores" object for SokoSave.
//
// Copyright (c), 1997,2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoScores.h,v 1.5 2002/01/29 20:33:29 sunshine Exp $
// $Log: SokoScores.h,v $
// Revision 1.5  2002/01/29 20:33:29  sunshine
// v17
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Added "runs" and "focus" scores columns to scores panel and to "New
//     Score" panel.
//
// Revision 1.4  2001/12/23 17:45:38  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the OpenStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//
// -*- Split new-score entry panel and functionality out of SokoScores and
//     into its own module, SokoNewScore.
//
// -*- For safety, SCORES is now written out immediately after a new score is
//     recorded, rather than only at program termination time.
//
// -*- Now remembers username from New Score panel as default for that panel
//     as a convenience to users of Windows 9x who don't actually login with
//     a username.
//
// -*- For safety, user defaults (including score panel column order and
//     widths) are now committed immediately, rather than at termination
//     time.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// -*- Added SokoAlerter which provides a convenience function used by the
//     new SokoPuzzleDelegate and SokoScoreDelegate implementations to send
//     alert messages to the user from those core modules.
//
// -*- Augmented all input/output logic so that it now deals gracefully with
//     line terminators from all common platforms; Unix (LF), Macintosh (CR),
//     and Windows/DOS (CRLF).
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//-----------------------------------------------------------------------------
#import <Foundation/NSObject.h>
#import "SokoPuzzle.h"
#import "SokoScore.h"
@class NSString, NSTableView, SokoPanel;

@interface SokoScores : NSObject
    {
    SokoPanel* panel;
    NSTableView* tableView;
    SokoScore scores;
    }

+ (void)launch;
+ (void)solved:(SokoPuzzle)puzzle
    moves:(int)moves
    pushes:(int)pushes
    runs:(int)runs
    focus:(int)focus
    name:(NSString*)name
    notes:(NSString*)notes;

@end

#endif // SokoScores_h
