//-----------------------------------------------------------------------------
// SokoPref-openstep.m
//
//	Preference related functionality for OpenStep/Mach.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPref-openstep.m,v 1.1 2001/12/23 18:02:42 sunshine Exp $
// $Log: SokoPref-openstep.m,v $
// Revision 1.1  2001/12/23 18:02:42  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the OpenStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Added the new pseudo-variable $(SokoUser) which points at the user's
//     "personal" file space.  This is where user-specific SokoSave files are
//     stored by default.  This variable complements the existing $(SokoSave)
//     variable.
//
// -*- Renamed soko_collapse() to soko_collapse_path().  Renamed
//     soko_expand() to soko_expand_path().
//
// -*- The path setting functions in SokoFile now invoke soko_collapse_path()
//     on all set operations.  This ensures that all paths displayed on the
//     preferences panel are properly collapsed, and removes the onus of this
//     task from the UI code.  Previously, soko_collapse_path() was only
//     called by the UI code for the puzzle path.
//
// -*- Added soko_normalize_path() and soko_denormalize_path() to SokoUtil.
//     All path manipulation functions now utilize these functions in order
//     to ensure correctness of path parsing and composition on all
//     platforms.
//
// -*- Added soko_set_puzzle_directory(), soko_set_save_directory(), and
//     soko_set_score_file() to SokoFile in order to complement the existing
//     "get" functions and to centralize control over these settings.
//
// -*- Added soko_get_default_puzzle_directory(),
//     get_default_save_directory(), and soko_get_default_score_file() to
//     SokoFile.  These functions return values appropriate for the
//     corresponding fields on the Preferences panel of each port when the
//     "Defaults" button is pressed.
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//
// -*- For safety, user defaults (including score panel column order and
//     widths) are now committed immediately, rather than at termination
//     time.
//
// -*- No longer assumes that default location for user-files is
//     $(HOME)/Library, in all cases.  Now uses
//     NSSearchPathForDirectoriesInDomains() to resolve $(SokoUser) if
//     available.  It is available on MacOS/X (Cocoa) and MacOS/X Server 1.0
//     (Rhapsody).  On MacOS/X, "Application Support/SokoSave" is appended to
//     the result of NSSearchPathForDirectoriesInDomains().  In other cases,
//     only "SokoSave" is appended.  For Windows, $(SokoUser) expands to the
//     "personal" folder (typically "My Documents"), if it exists.  If not,
//     then it expands to the first of the following which exist: $(HOME),
//     $(TEMP), $(TMP), root of drive containing "windows" directory, or root
//     of current drive.
//
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// -*- Worked around an AppKit bug on Windows in which the Preferences panel
//     would suddenly appear on the "Window" menu when -setDocumentEdited:
//     was invoked even though panels are not supposed to appear on this
//     menu.  This problem was further compounded by the fact that the menu
//     item would remain dangling on the menu even after the Preferences
//     panel was closed.
//
//-----------------------------------------------------------------------------
#import "SokoPool.h"
#import <Foundation/NSPathUtilities.h>
#import <Foundation/NSString.h>

//-----------------------------------------------------------------------------
// soko_application_data_path
//	Return the base path into which application-specific files should be
//	stored for the current user.  The returned path does not include the
//	"SokoSave" suffix.  On OpenStep/Mach, this returns "~/Library".
//-----------------------------------------------------------------------------
char const* soko_application_data_path( SokoPool pool )
    {
    return [[NSHomeDirectory() stringByAppendingPathComponent:@"Library"]
	fileSystemRepresentation];
    }
