#ifndef SokoMatrixTriangle_h
#define SokoMatrixTriangle_h
//-----------------------------------------------------------------------------
// SokoMatrixTriangle.h
//
//	A hexagonal-celled matrix for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrixTriangle.h,v 1.1 2002/02/19 09:29:11 sunshine Exp $
// $Log: SokoMatrixTriangle.h,v $
// Revision 1.1  2002/02/19 09:29:11  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
//-----------------------------------------------------------------------------
#import "SokoMatrix.h"

@interface SokoMatrixTriangle : SokoMatrix

+ (NSImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (void)drawRect:(NSRect)r;
- (void)drawCellAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NSPoint)p;

@end

#endif // SokoMatrixTriangle_h
