#ifndef SokoMatrixHexagon_h
#define SokoMatrixHexagon_h
//-----------------------------------------------------------------------------
// SokoMatrixHexagon.h
//
//	A hexagonal-celled matrix for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrixHexagon.h,v 1.2 2002/02/19 09:28:54 sunshine Exp $
// $Log: SokoMatrixHexagon.h,v $
// Revision 1.2  2002/02/19 09:28:54  sunshine
// v18
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
// Revision 1.1  2002/01/29 20:27:31  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- Rewrote SokoMatrix.  It is now a generic base class for rendering
//     grids.  No longer based upon NSMatrix (which was only capable of
//     supporting rectangular cells).  Custom rendering is now done, rather
//     than relying upon NSMatrix.  Consequently, animation speed has
//     increased by a factor of five or more.
//
// -*- Added SokoMatrixSquare, a subclass of SokoMatrix, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added SokoMatrixHexagon, a subclass of SokoMatrix, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#import "SokoMatrix.h"

@interface SokoMatrixHexagon : SokoMatrix

+ (NSImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (void)drawRect:(NSRect)r;
- (void)drawCellAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NSPoint)p;

@end

#endif // SokoMatrixHexagon_h
