#ifndef SokoMatrix_h
#define SokoMatrix_h
//-----------------------------------------------------------------------------
// SokoMatrix.h
//
//	A custom Matrix for SokoSave.
//
// Copyright (c), 1997,2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrix.h,v 1.6 2002/02/19 09:28:49 sunshine Exp $
// $Log: SokoMatrix.h,v $
// Revision 1.6  2002/02/19 09:28:49  sunshine
// v18
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
// Revision 1.5  2002/01/29 20:27:43  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- Rewrote SokoMatrix.  It is now a generic base class for rendering
//     grids.  No longer based upon NSMatrix (which was only capable of
//     supporting rectangular cells).  Custom rendering is now done, rather
//     than relying upon NSMatrix.  Consequently, animation speed has
//     increased by a factor of five or more.
//
// -*- Added SokoMatrixSquare, a subclass of SokoMatrix, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added SokoMatrixHexagon, a subclass of SokoMatrix, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//
// Revision 1.4  2001/12/23 16:08:05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the OpenStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//-----------------------------------------------------------------------------
#import <AppKit/NSView.h>
#import "SokoPuzzle.h"
@class NSImage;

@interface SokoMatrix : NSView
    {
    int rows;
    int cols;
    NSImage** matrix;
    id delegate;
    }

+ (NSImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (void)dealloc;
- (void)setDelegate:(id)d;
- (id)delegate;
- (void)drawCellAtRow:(int)r column:(int)c;
- (void)setCellType:(SokoCellType)type atRow:(int)r column:(int)c;
- (NSImage*)imageAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NSPoint)p;
- (BOOL)acceptsFirstResponder;
- (BOOL)acceptsFirstMouse:(NSEvent*)e;
- (void)mouseDown:(NSEvent*)e;
- (void)mouseUp:(NSEvent*)e;
- (void)mouseDragged:(NSEvent*)e;
- (void)rightMouseDown:(NSEvent*)e;
- (void)rightMouseUp:(NSEvent*)e;
- (void)rightMouseDragged:(NSEvent*)e;
- (void)keyDown:(NSEvent*)e;
- (void)keyUp:(NSEvent*)e;

@end

#endif // SokoMatrix_h
