//-----------------------------------------------------------------------------
// SokoInfo.m
//
//	Info panel object for SokoSave.
//
// Copyright (c), 1997,2001, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.m,v 1.5 2001/12/23 15:50:00 sunshine Exp $
// $Log: SokoInfo.m,v $
// Revision 1.5  2001/12/23 15:50:00  sunshine
// v15
// -*- Converted the documentation from RTFD format to HTML format.
//     Documentation is no longer embedded in a scrollable text object on the
//     Info panel.  Instead, a "Help" menu item now displays the help file
//     via a web browser.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  On MacOS/X, it knows how to
//     dispatch any URL understood by -[NSWorkspace openURL:].  On Windows,
//     it knows how to dispatch any URL understood by ShellExecute().  On
//     MacOS/X Server 1.0 (Rhapsody), OpenStep/Mach, and NextStep, it knows
//     how to dispatch mailto: URLs directly; all others are handed off to
//     OmniWeb's "Open URL" service.
//
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// Revision 1.4  2001/08/20 10:11:35  sunshine
// v12.1 -- release 2.1
// -*- Now compiles cleanly on MacOS/X (though I do not yet have a project
//     file or main-menu nib for MacOS/X).  Clean compilation on MacOS/X
//     required importing several additional headers into SokoBoard.m,
//     SokoInfo.m, and SokoScore.m.  Also, had to work around problem caused
//     by change in prototype of -applicationShouldTerminate: between MacOS/X
//     Server 1.0 and MacOS/X.  Instead, SokoApp.m now implements
//     -applicationWillTerminate: which has the same prototype on both
//     platforms.
//
// Revision 1.3  2001/08/19 12:55:39  sunshine
// v11.1
// -*- Added SokoHelp.rtfd which contains the user documentation which used to
//     reside directly within the SokoInfo.nib.  This documentation is now
//     loaded into the text section of the SokoInfo.nib from SokoHelp.rtfd at
//     run-time.
//
// -*- Now sets the miniwindow icon for the SokoInfo panel.
//
// -*- SokoInfo now translates spaces in displayed numbers to dots, thus the
//     package number now displays as "10.1" rather than "10 1".
//
// -*- Converted from Objective-C++ to pure Objective-C.  Changed file
//     extensions from .M to .m, and .cc to .c.  This change makes it easier
//     to support both GNUstep and MacOS/X, neither of which feature an
//     Objective-C++ compiler (though MacOS/X will reportedly support
//     Objective-C++ at some point in the future).
//-----------------------------------------------------------------------------
#import "SokoInfo.h"
#import "SokoDefs.h"
#import "SokoBuild.h"
#import "SokoRelease.h"
#import "SokoURL.h"
#import "SokoWindow.h"
#import <AppKit/NSImage.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSTextField.h>
#import <Foundation/NSString.h>

@implementation SokoInfo

//-----------------------------------------------------------------------------
// setField:value:append:
//-----------------------------------------------------------------------------
- (void)setField:(NSTextField*)field value:(char const*)value
    append:(BOOL)append
    {
    NSString* s;
    if (!append)
	s = [NSString stringWithCString:value];
    else
	s = [[field stringValue] stringByAppendingFormat:@" %s", value];
    [field setStringValue:s];
    }


//-----------------------------------------------------------------------------
// setUrl:value:email:
//-----------------------------------------------------------------------------
- (void)setUrl:(SokoURL*)field value:(char const*)value email:(BOOL)email
    {
    NSString* str_fmt = (email ? @"<%s>" : @"%s");
    NSString* url_fmt = (email ? @"mailto:%s" : @"http://%s/");
    NSString* str = [NSString stringWithFormat:str_fmt, value];
    NSString* url = [NSString stringWithFormat:url_fmt, value];
    [field setStringValue:str url:url];
    }


//-----------------------------------------------------------------------------
// init
//-----------------------------------------------------------------------------
- (id)init
    {
    [super init];
    [NSBundle loadNibNamed:@"SokoInfo" owner:self];
    [panel setMiniwindowImage:[NSImage imageNamed:@"SokoSave"]];
    [panel center];
    [self setField:authorMcCarthy value:SOKO_AUTHOR_MCCARTHY append:NO ];
    [self setField:authorSunshine value:SOKO_AUTHOR_SUNSHINE append:NO ];
    [self setField:releaseField   value:SOKO_RELEASE         append:YES];
    [self setField:buildField     value:SOKO_BUILD           append:YES];
    [self setUrl:mailMcCarthy     value:SOKO_MAIL_MCCARTHY   email: YES];
    [self setUrl:mailSunshine     value:SOKO_MAIL_SUNSHINE   email: YES];
    [self setUrl:webPage          value:SOKO_WEB_PAGE        email: NO ];
    return self;
    }


//-----------------------------------------------------------------------------
// dealloc
//-----------------------------------------------------------------------------
- (void)dealloc
    {
    [panel setDelegate:0];
    [panel close];
    [panel release];
    [super dealloc];
    }


//-----------------------------------------------------------------------------
// startTracking
//-----------------------------------------------------------------------------
- (void)startTracking
    {
    [mailMcCarthy startTracking];
    [mailSunshine startTracking];
    [webPage startTracking];
    }


//-----------------------------------------------------------------------------
// stopTracking
//-----------------------------------------------------------------------------
- (void)stopTracking
    {
    [mailMcCarthy stopTracking];
    [mailSunshine stopTracking];
    [webPage stopTracking];
    }


//-----------------------------------------------------------------------------
// windowDidBecomeKey:
//-----------------------------------------------------------------------------
- (void)windowDidBecomeKey:(NSNotification*)n
    {
    [self startTracking];
    }


//-----------------------------------------------------------------------------
// windowDidResignKey:
//-----------------------------------------------------------------------------
- (void)windowDidResignKey:(NSNotification*)n
    {
    [self stopTracking];
    }


//-----------------------------------------------------------------------------
// windowShouldClose:
//-----------------------------------------------------------------------------
- (BOOL)windowShouldClose:(id)sender
    {
    [self stopTracking];
    return YES;
    }


//-----------------------------------------------------------------------------
// activate
//-----------------------------------------------------------------------------
- (void)activate
    {
    [panel makeKeyAndOrderFront:self];
    }


//-----------------------------------------------------------------------------
// launch
//-----------------------------------------------------------------------------
+ (void)launch
    {
    static id instance = 0;
    if (instance == 0)
	instance = [[self alloc] init];
    [instance activate];
    }

@end
