#ifndef SokoInfo_h
#define SokoInfo_h
//-----------------------------------------------------------------------------
// SokoInfo.h
//
//	Info panel object for SokoSave.
//
// Copyright (c), 1997,2001, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.h,v 1.4 2001/12/23 15:49:06 sunshine Exp $
// $Log: SokoInfo.h,v $
// Revision 1.4  2001/12/23 15:49:06  sunshine
// v15
// -*- Converted the documentation from RTFD format to HTML format.
//     Documentation is no longer embedded in a scrollable text object on the
//     Info panel.  Instead, a "Help" menu item now displays the help file
//     via a web browser.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  On MacOS/X, it knows how to
//     dispatch any URL understood by -[NSWorkspace openURL:].  On Windows,
//     it knows how to dispatch any URL understood by ShellExecute().  On
//     MacOS/X Server 1.0 (Rhapsody), OpenStep/Mach, and NextStep, it knows
//     how to dispatch mailto: URLs directly; all others are handed off to
//     OmniWeb's "Open URL" service.
//
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// Revision 1.3  2001/08/19 12:55:34  sunshine
// v11.1
// -*- Added SokoHelp.rtfd which contains the user documentation which used to
//     reside directly within the SokoInfo.nib.  This documentation is now
//     loaded into the text section of the SokoInfo.nib from SokoHelp.rtfd at
//     run-time.
//
// -*- Now sets the miniwindow icon for the SokoInfo panel.
//
// -*- SokoInfo now translates spaces in displayed numbers to dots, thus the
//     package number now displays as "10.1" rather than "10 1".
//
// -*- Converted from Objective-C++ to pure Objective-C.  Changed file
//     extensions from .M to .m, and .cc to .c.  This change makes it easier
//     to support both GNUstep and MacOS/X, neither of which feature an
//     Objective-C++ compiler (though MacOS/X will reportedly support
//     Objective-C++ at some point in the future).
//-----------------------------------------------------------------------------
#import <Foundation/NSObject.h>
@class NSCursor, NSTextField, SokoPanel, SokoURL;

@interface SokoInfo : NSObject
    {
    SokoPanel* panel;
    NSTextField* authorMcCarthy;
    NSTextField* authorSunshine;
    SokoURL* mailMcCarthy;
    SokoURL* mailSunshine;
    SokoURL* webPage;
    NSTextField* releaseField;
    NSTextField* buildField;
    }

+ (void)launch;

@end

#endif // SokoInfo_h
