#ifndef SokoConfig_h
#define SokoConfig_h
//-----------------------------------------------------------------------------
// SokoConfig.h
//
//	Configuration information for SokoSave.
//
// Copyright (c), 1997,2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//
// Platform and O/S specific definitions:
//
// SOKO_DEFERRED_LAUNCH
//	On MacOS/X, MacOS/X Server 1.0 (Rhapsody) for Mach, and OpenStep for
//	Mach, the action of automatically opening the "default" maze is
//	deferred until the application becomes active for the first time.  This
//	prevents it from cluttering up the screen before it is actually needed
//	(such as if it is auto-launched at login time).  However, under
//	Microsoft Windows, an application _must_ have at least one window
//	on-screen the main menu is attached to the window, rather than being
//	stand-alone as it is under Mach.  Hence, opening the default maze is
//	not deferred for Windows.
//
// SOKO_REGISTER_FILE_ASSOCIATIONS
//	On some platforms, file associations (such as .sokomaze and .sokosave)
//	are gleaned directly from the application wrapper.  On others, such as
//	Microsoft Windows, SokoSave must be associated with these extensions
//	manually.  Also defines SOKO_FILE_ICON_EXTENSION with the appropriate
//	filename extension for the asociation's icon file.
//
// SOKO_CUSTOM_WINDOW_FINALIZE
//	Some platforms may need to perform some extra steps to correctly
//	initialize windows after the actual platform-specific window
//	representation has been created.  For non-deferred windows, the
//	platform-specific representation is created immediately.  For
//	non-deferred, it is created the first time the window is ordered
//	on-screen.
//
// SOKO_PANEL_DOC_EDITED_BROKEN
//	On some platforms, -setDocumentEdited: is broken.  Even if a
//	window/panel has been excluded from the "Window" menu, as soon as
//	-setDocumentEdited: is invoked, the window suddenly appears in the
//	menu.  Furthermore, closing the window fails to remove it from the menu
//	(even though closing a window would normally remove it from the
//	"Window" menu).
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoConfig.h,v 1.5 2002/01/29 20:31:03 sunshine Exp $
// $Log: SokoConfig.h,v $
// Revision 1.5  2002/01/29 20:31:03  sunshine
// v17
// -*- Added descriptions for new .sokohex, .xsb, and .hsb file associations
//     to CustomInfo.plist.  Also removed hard-coded .ico extension from icon
//     names in this list, since the extensions were meaningful only for
//     Windows.
//
// Revision 1.4  2001-12-23 11:18:54-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Worked around an AppKit bug on Windows which appeared in this release
//     when small versions of the icons were incorporated into the ICO files.
//     The AppKit failed to use these small icons in the window title bars.
//     Instead, it used a scrunched version of the large icon, which was
//     quite ugly.
//
// -*- Worked around an AppKit bug on Windows in which the Preferences panel
//     would suddenly appear on the "Window" menu when -setDocumentEdited:
//     was invoked even though panels are not supposed to appear on this
//     menu.  This problem was further compounded by the fact that the menu
//     item would remain dangling on the menu even after the Preferences
//     panel was closed.
//-----------------------------------------------------------------------------
#if defined(__WIN32__)
# undef  SOKO_DEFERRED_LAUNCH
#else
# define SOKO_DEFERRED_LAUNCH
#endif

#if defined(__WIN32__)
# define SOKO_REGISTER_FILE_ASSOCIATIONS
# define SOKO_FILE_ICON_EXTENSION @"ico"
#else
# undef  SOKO_REGISTER_FILE_ASSOCIATIONS
#endif

#if defined(__WIN32__)
# define SOKO_CUSTOM_WINDOW_FINALIZE
#else
# undef  SOKO_CUSTOM_WINDOW_FINALIZE
#endif

#if defined(__WIN32__)
# define SOKO_PANEL_DOC_EDITED_BROKEN
#else
# undef  SOKO_PANEL_DOC_EDITED_BROKEN
#endif

#endif // SokoConfig_h
