#ifndef SokoBoard_h
#define SokoBoard_h
//-----------------------------------------------------------------------------
// SokoBoard.h
//
//	Implementation of a Sokoban puzzle board for SokoSave.
//
// Copyright (c), 1997,2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoBoard.h,v 1.5 2002/01/29 20:35:17 sunshine Exp $
// $Log: SokoBoard.h,v $
// Revision 1.5  2002/01/29 20:35:17  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer fills areas outside the puzzle with wall segments.  Doing so
//     causes some "artistic" effect to be lost from some puzzles.  Added
//     SokoCellType SOKO_CELL_NULL to support of this.
//
// -*- Added SokoPuzzleStyle enumeration to SokoPuzzle.  Styles are
//     SOKO_STYLE_SQUARE and SOKO_STYLE_HEXAGON.
//
// -*- Now recognize these additional file extensions: .xsb, .hsb, .sokohex.
//
// -*- Removed soko_get_puzzle_extension() and soko_get_save_extension() from
//     SokoFile.
//
// -*- Relocated functionality of soko_save_filename_for_puzzle(),
//     soko_puzzle_name_for_level(), and soko_level_for_puzzle_name() from
//     SokoFile to SokoPuzzle, where they are class methods of SokoPuzzle.
//
// -*- Added get_puzzle_extensions(), get_puzzle_extensions_count(), and
//     get_save_extension() as class methods to SokoPuzzle.  There are now
//     multiple recognized puzzle extensions, rather than just the one
//     (.sokomaze).
//
// -*- Added file_is_puzzle(), file_is_save_game(), and get_file_style()
//     class methods to SokoPuzzle.
//
// -*- Extended keyboard movement support.  Numeric keypad can now be used,
//     as well as standard arrow keys.  Added key equivalents for hexagonal
//     puzzles.
//
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Added "runs" and "focus" scores controls to SokoBoard.
//
// -*- Rewrote SokoMatrix.  It is now a generic base class for rendering
//     grids.  No longer based upon NSMatrix (which was only capable of
//     supporting rectangular cells).  Custom rendering is now done, rather
//     than relying upon NSMatrix.  Consequently, animation speed has
//     increased by a factor of five or more.
//
// -*- Added SokoMatrixSquare, a subclass of SokoMatrix, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added SokoMatrixHexagon, a subclass of SokoMatrix, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//
// Revision 1.4  2001/12/23 18:19:38  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the OpenStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//
// -*- Augmented all input/output logic so that it now deals gracefully with
//     line terminators from all common platforms; Unix (LF), Macintosh (CR),
//     and Windows/DOS (CRLF).
//
// -*- SokoPuzzle now understands the token "+" as player-safe, since this is
//     what is used by XSokoban, and used in numerous existing add-on
//     puzzles.  The "^" token which was historically understood by SokoSave
//     is still recognized, but is no longer published in the documentation.
//
// -*- SokoPuzzle no longer complains about loading puzzles with unreachable
//     crates, provided that those crates are already on goal squares.  This
//     allows some existing add-on puzzles to be used with SokoSave.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Renamed soko_save_filename_for_maze_name() and
//     soko_maze_name_for_level() in SokoFile to to
//     soko_save_filename_for_puzzle_name() and soko_puzzle_name_for_level(),
//     respectively.
//
// -*- Added soko_level_for_puzzle_name() to SokoFile.  This function is used
//     by the new "Next Puzzle" menu item and shortcut.
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//
// -*- Added a "Next Puzzle" menu item (and toolbar shortcut), which opens
//     the puzzle that comes "next" after the puzzle in the active window.
//
// -*- Changed the logic used to locate the puzzle which is opened
//     automatically at program launch time.  Previously, it simply opened a
//     .sokomaze file with the level number recorded as the "highest" level.
//     Unfortunately, if the user then tried to open a saved game file with
//     the same level number, the program would not actually open the saved
//     game because it thought that the game was already open.  This made it
//     very difficult for the user to continue a saved game which matched the
//     "highest" level.  The user first has to close the "new" game and then
//     open the "saved" game.  This problem was even further complicated on
//     the Windows platform where closing the "new" game would cause the
//     program to terminate if that was the only menu-bearing window.  Since
//     it is probable that a user may save a game before actually arriving at
//     the solution with the intention of returning to that game later, the
//     program now makes it much easier to return to the saved game.  Now, at
//     launch time, the program first checks for a "saved" game matching the
//     "highest" level and open that if present.  If not, then it falls back
//     to opening a new game.
//
// -*- Completely re-worked playback animation logic.  The pseudo-modal loop
//     which specially filtered and dispatched events is no longer used.
//     Instead, animation is now driven from the main event loop and occurs
//     in tandem with the receipt and processing of normal user events.
//     Rather than trying to restrict and filter user events, all events are
//     now handled as usual, except that some events may have the side-effect
//     of aborting playback.  There are now several different mechanisms for
//     aborting playback: pressing the stop button, pressing Escape, clicking
//     in the puzzle view, switching to a different window, deactivating the
//     application (for instance, by clicking on the window of a another
//     application, or hiding SokoSave).
//
// -*- Now remembers the directory from which a new game was loaded during a
//     session, and seeds the New Game open panel with that location.  This
//     makes it more convenient for the user to start new games from a
//     directory other than the default New Game directory.  (It was very
//     annoying for the program to revert to the factory directory each time
//     New Game was invoked.)
//
// -*- Added SokoAlerter which provides a convenience function used by the
//     new SokoPuzzleDelegate and SokoScoreDelegate implementations to send
//     alert messages to the user from those core modules.
//
// -*- Added SokoWindow and SokoPanel, which are subclasses of NSWindow and
//     NSPanel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  This allows bugs in
//     the AppKit window and panel classes to be overcome more easily.  For
//     instance, the Windows port works around several Windows-specific
//     AppKit bugs by overriding certain methods in these classes.
//
// -*- Directional movement buttons on SokoBoard window are now connected to
//     -directionPressed: and diagonalPressed:, rather than each being
//     connected to a dedicated method.
//
// -*- Renamed -[SokoBoard inspectPlaybackSlider:] to -inspectSlider:.
//
// -*- Connected the "Animate" switch on SokoBoard to the new -[SokoBoard
//     animateToggled:] method.
//
// -*- On Windows, now ensures that the puzzle view does not get occluded by
//     the menu if the user changes display preferences via the Control
//     Panel.  For instance, the user might assign a larger font to the menu,
//     or the menu might wrap, thus occluding the puzzle view.  This is
//     accomplished by catching the WM_SETTINGCHANGED message from Windows
//     and adjusting the window frame as needed.
//
// -*- Worked around an AppKit bug on Windows 9x which caused the window size
//     of SokoBoard windows to become completely corrupt when miniaturized.
//     This bug only seems to affect non-resizeable windows (such as
//     SokoBoard) and only occurs on Windows 9x.  (Windows NT and 2000 are
//     not afflicted.)
//-----------------------------------------------------------------------------
#import <Foundation/NSObject.h>
#import "SokoPuzzle.h"
@class NSBox, NSButton, NSSlider, NSTextField, SokoWindow, SokoMatrix;

@interface SokoBoard : NSObject
    {
    NSButton* animateSwitch;
    SokoMatrix* cellMatrix;
    NSBox* controlBox;
    NSButton* moveDownBtn;
    NSButton* moveDownLeftBtn;
    NSButton* moveDownRightBtn;
    NSButton* moveLeftBtn;
    NSButton* moveRightBtn;
    NSButton* moveUpBtn;
    NSButton* moveUpLeftBtn;
    NSButton* moveUpRightBtn;
    NSTextField* numMovesFld;
    NSTextField* numPushesFld;
    NSTextField* numRunsFld;
    NSTextField* numFocusFld;
    NSSlider* playbackSlider;
    NSButton* redoMoveBtn;
    NSButton* redoPushBtn;
    NSTextField* solvedFld;
    NSButton* stopBtn;
    NSButton* undoMoveBtn;
    NSButton* undoPushBtn;
    SokoWindow* window;
    SokoPuzzle puzzle;
    BOOL nextPuzzleExists;
    float minControlBoxWidth;
    }

// Public Interface -----------------------------------------------------------
+ (BOOL)openPuzzle:(NSString*)path;
+ (BOOL)openDefaultPuzzle;
+ (BOOL)choosePuzzleFromDirectory:(NSString*)dir;
+ (void)newPuzzle;
+ (void)openPuzzle;
+ (void)saveAllPuzzles;

// Nib Interface --------------------------------------------------------------
- (void)animateToggled:(id)sender;
- (void)inspectSlider:(id)sender;
- (void)directionPressed:(id)sender;
- (void)diagonalPressed:(id)sender;
- (void)stopPressed:(id)sender;
- (void)redoMove:(id)sender;
- (void)undoMove:(id)sender;
- (void)redoPush:(id)sender;
- (void)undoPush:(id)sender;
- (void)openNextPuzzle:(id)sender;
- (void)save:(id)sender;
- (void)saveAs:(id)sender;
- (BOOL)validateMenuItem:(id)item;

// Delegate Interface ---------------------------------------------------------
- (void)recordMoves:(int)m pushes:(int)m runs:(int)r focus:(int)f;
- (void)recordLevel:(int)level;
- (void)setSolved:(BOOL)solved;
- (void)setDirty:(BOOL)dirty;
- (void)refreshControls;
- (void)refreshAllCells;
- (void)refreshCells:(SokoCell const*)cells count:(int)ncells;
- (BOOL)shouldAnimatePlayback;
- (int)playbackThreshold;
- (void)beginPlayback;
- (void)endPlayback;
- (void)beginAnimation;
- (void)endAnimation;
- (void)beginDrag;
- (void)endDrag;
- (void)processEvents:(BOOL)awaitEvent;

@end

#endif // SokoBoard_h
