#ifndef SokoApp_h
#define SokoApp_h
//-----------------------------------------------------------------------------
// SokoApp.h
//
//	Application delegate for SokoSave.
//
// Copyright (c), 1997,2001, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoApp.h,v 1.4 2001/12/23 18:10:50 sunshine Exp $
// $Log: SokoApp.h,v $
// Revision 1.4  2001/12/23 18:10:50  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the OpenStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Converted the documentation from RTFD format to HTML format.
//     Documentation is no longer embedded in a scrollable text object on the
//     Info panel.  Instead, a "Help" menu item now displays the help file
//     via a web browser.
//
// -*- Added a "Help" menu item which opens the HTML help file in a web
//     browser.  Previously, the help information was contained in an RTFD
//     file and loaded directly into a text object on the Info panel.
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//
// -*- Changed the logic used to locate the puzzle which is opened
//     automatically at program launch time.  Previously, it simply opened a
//     .sokomaze file with the level number recorded as the "highest" level.
//     Unfortunately, if the user then tried to open a saved game file with
//     the same level number, the program would not actually open the saved
//     game because it thought that the game was already open.  This made it
//     very difficult for the user to continue a saved game which matched the
//     "highest" level.  The user first has to close the "new" game and then
//     open the "saved" game.  This problem was even further complicated on
//     the Windows platform where closing the "new" game would cause the
//     program to terminate if that was the only menu-bearing window.  Since
//     it is probable that a user may save a game before actually arriving at
//     the solution with the intention of returning to that game later, the
//     program now makes it much easier to return to the saved game.  Now, at
//     launch time, the program first checks for a "saved" game matching the
//     "highest" level and open that if present.  If not, then it falls back
//     to opening a new game.
//
// -*- For safety, user defaults (including score panel column order and
//     widths) are now committed immediately, rather than at termination
//     time.
//
// -*- Renamed old SokoWindows.c to SokoApp-windows.c since this
//     Windows-specific module is related to SokoApp.  (Also, this helps to
//     disambiguate it from the new SokoWindow class and implementation
//     file.)
//
// -*- When registering file associations on Windows, now uses an appropriate
//     description for each association, rather than the generic "SokoSave
//     Document".  Added CustomInfo.plist which contains an appropriate
//     description for each file extension.
//
// -*- Created icons for .sokomaze and .sokosave so that they can be
//     distinguished from the application and from each other on platforms
//     (like Windows) which hide the file extension by default.  Created both
//     ICO and TIFF formats.
//
// Revision 1.3  2001/08/19 13:02:15  sunshine
// v11.1
// -*- On Windows, file associations for the .sokomaze and .sokosave
//     extensions are programmatically added to the registry if absent or
//     incorrect.  This allows users to double-click on these files and have
//     SokoSave automatically launched as a result.
//
// -*- The static `checked' variable in SokoApp.m is now an instance variable
//     of the SokoApp class and has been renamed to `autoOpenMaze'.
//
// -*- Converted from Objective-C++ to pure Objective-C.  Changed file
//     extensions from .M to .m, and .cc to .c.  This change makes it easier
//     to support both GNUstep and MacOS/X, neither of which feature an
//     Objective-C++ compiler (though MacOS/X will reportedly support
//     Objective-C++ at some point in the future).
//-----------------------------------------------------------------------------
#import <Foundation/NSObject.h>

@interface SokoApp : NSObject
    {
    BOOL autoOpenPuzzle;
    }

- (id)init;
- (void)launchInfo:(id)sender;
- (void)launchInstructions:(id)sender;
- (void)launchPreferences:(id)sender;
- (void)launchScores:(id)sender;
- (void)new:(id)sender;
- (void)open:(id)sender;
- (void)saveAll:(id)sender;

@end

#endif // SokoApp_h
