//-----------------------------------------------------------------------------
// SokoAlerter.m
//
//	Basic implementation of SokoCore alert message functionality.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoAlerter.m,v 1.1 2001/12/23 15:58:43 sunshine Exp $
// $Log: SokoAlerter.m,v $
// Revision 1.1  2001/12/23 15:58:43  sunshine
// v15
// -*- Added SokoAlerter which provides a convenience function used by the
//     new SokoPuzzleDelegate and SokoScoreDelegate implementations to send
//     alert messages to the user from those core modules.
//
//-----------------------------------------------------------------------------
#import "SokoAlerter.h"
#import <AppKit/NSPanel.h>
#import <Foundation/NSString.h>

//-----------------------------------------------------------------------------
// SokoSendAlert
//-----------------------------------------------------------------------------
void SokoSendAlert( SokoAlert severity, char const* title, char const* msg )
    {
    NSString* t = [NSString stringWithCString:title];
    NSString* m = [NSString stringWithCString:msg];
    if (severity == SOKO_ALERT_INFO)
	NSRunInformationalAlertPanel( t, m, 0, 0, 0 );
    else if (severity == SOKO_ALERT_ERROR)
	NSRunCriticalAlertPanel( t, m, 0, 0, 0 );
    else // (severity == SOKO_ALERT_WARNING)
	NSRunAlertPanel( t, m, 0, 0, 0 );
    }
