#ifndef SokoURL_h
#define SokoURL_h
//-----------------------------------------------------------------------------
// SokoURL.h
//
//	Subclass of TextField which displays and dispatches a URL.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL.h,v 1.1 2001/12/23 15:31:39 sunshine Exp $
// $Log: SokoURL.h,v $
// Revision 1.1  2001/12/23 15:31:39  sunshine
// v15
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  It handles mailto: URLs directly;
//     all others are handed off to OmniWeb's "Open URL" service.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
//-----------------------------------------------------------------------------
#import <appkit/TextField.h>

@interface SokoURL : TextField
    {
    char* url;
    BOOL urlValid;
    BOOL trackingRectEstablished;
    BOOL mouseInside;
    BOOL trackingMouse;
    BOOL underlined;
    }

- (id)initFrame:(NXRect const*)r;
- (id)free;
- (id)setStringValue:(char const*)s;
- (id)setStringValue:(char const*)s url:(char const*)url;
- (id)setUrl:(char const*)url;
- (char const*)url;
- (BOOL)dispatchUrl;
- (void)startTracking;
- (void)stopTracking;

@end

#endif // SokoURL_h
