#ifndef SokoNewScore_h
#define SokoNewScore_h
//-----------------------------------------------------------------------------
// SokoNewScore.h
//
//	Panel allowing user input upon new high-score for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoNewScore.h,v 1.2 2002/01/29 20:07:51 sunshine Exp $
// $Log: SokoNewScore.h,v $
// Revision 1.2  2002/01/29 20:07:51  sunshine
// v17
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Added "runs" and "focus" scores columns to scores panel and to "New
//     Score" panel.
//
// -*- Now strips the file extension from the puzzle name on the new-score
//     panel.
//
// Revision 1.1  2001/12/23 16:33:46  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Rewrote the NextStep port so that it utilizes the new "sokocore" game
//     library rather than implementing that logic directly.
//
// -*- Split new-score entry panel and functionality out of SokoScores and
//     into its own module, SokoNewScore.
//
// -*- Now remembers username from New Score panel as default for that panel
//     as a convenience to users rather than always seeding it with the
//     username.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Added SokoWindow and SokoPanel which are subclasses of Window and
//     Panel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  Although these
//     classes currently implement no extra functionality, they provide
//     convenient hooks for the addition of new functionality in the future,
//     if needed.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//-----------------------------------------------------------------------------
#import <objc/Object.h>
#import "SokoPuzzle.h"
@class Button, SokoPanel, TextField;

@interface SokoNewScore : Object
    {
    SokoPanel* panel;
    TextField* focusField;
    TextField* movesField;
    TextField* nameField;
    TextField* notesField;
    TextField* pushesField;
    TextField* puzzleField;
    TextField* runsField;
    Button* okayButton;
    char* storedName;
    }

+ (void)solved:(SokoPuzzle)puzzle moves:(int)moves pushes:(int)pushes
    runs:(int)runs focus:(int)focus;

@end

#endif // SokoNewScore_h
