#ifndef SokoMatrixTriangle_h
#define SokoMatrixTriangle_h
//-----------------------------------------------------------------------------
// SokoMatrixTriangle.h
//
//	A hexagonal-celled matrix for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrixTriangle.h,v 1.1 2002/02/19 08:57:06 sunshine Exp $
// $Log: SokoMatrixTriangle.h,v $
// Revision 1.1  2002/02/19 08:57:06  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated the user-interface movement constraints into SokoPuzzle
//     rather than having the same code repeated in each port.  This code
//     decides whether or not the direction movement buttons in the
//     user-interface should be enabled depending upon cell type,
//     orientation, etc.  Added the SokoPuzzle methods can_move_constrained()
//     and can_move_diagonal_constrained() to complement the existing
//     can_move() and can_move_diagonal().
//
//-----------------------------------------------------------------------------
#import "SokoMatrix.h"

@interface SokoMatrixTriangle : SokoMatrix

+ (NXImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (id)drawSelf:(NXRect const*)r :(int)n;
- (void)drawCellAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NXPoint const*)p;

@end

#endif // SokoMatrixTriangle_h
