#ifndef SokoMatrixHexagon_h
#define SokoMatrixHexagon_h
//-----------------------------------------------------------------------------
// SokoMatrixHexagon.h
//
//	A hexagonal-celled matrix for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrixHexagon.h,v 1.2 2002/02/19 08:57:11 sunshine Exp $
// $Log: SokoMatrixHexagon.h,v $
// Revision 1.2  2002/02/19 08:57:11  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated the user-interface movement constraints into SokoPuzzle
//     rather than having the same code repeated in each port.  This code
//     decides whether or not the direction movement buttons in the
//     user-interface should be enabled depending upon cell type,
//     orientation, etc.  Added the SokoPuzzle methods can_move_constrained()
//     and can_move_diagonal_constrained() to complement the existing
//     can_move() and can_move_diagonal().
//
// Revision 1.1  2002/01/29 20:11:26  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- Rewrote SokoMatrix.  It is now a generic base class for rendering
//     grids.  No longer based upon Matrix (which was only capable of
//     supporting rectangular cells).  Custom rendering is now done, rather
//     than relying upon Matrix.  Consequently, animation speed has increased
//     by a factor of five or more.
//
// -*- Added SokoMatrixSquare, a subclass of SokoMatrix, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added SokoMatrixHexagon, a subclass of SokoMatrix, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#import "SokoMatrix.h"

@interface SokoMatrixHexagon : SokoMatrix

+ (NXImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (id)drawSelf:(NXRect const*)r :(int)n;
- (void)drawCellAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NXPoint const*)p;

@end

#endif // SokoMatrixHexagon_h
