#ifndef SokoMatrix_h
#define SokoMatrix_h
//-----------------------------------------------------------------------------
// SokoMatrix.h
//
//	A custom Matrix for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMatrix.h,v 1.5 2002/02/19 08:57:01 sunshine Exp $
// $Log: SokoMatrix.h,v $
// Revision 1.5  2002/02/19 08:57:01  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated the user-interface movement constraints into SokoPuzzle
//     rather than having the same code repeated in each port.  This code
//     decides whether or not the direction movement buttons in the
//     user-interface should be enabled depending upon cell type,
//     orientation, etc.  Added the SokoPuzzle methods can_move_constrained()
//     and can_move_diagonal_constrained() to complement the existing
//     can_move() and can_move_diagonal().
//
// Revision 1.4  2002/01/29 20:11:31  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- Rewrote SokoMatrix.  It is now a generic base class for rendering
//     grids.  No longer based upon Matrix (which was only capable of
//     supporting rectangular cells).  Custom rendering is now done, rather
//     than relying upon Matrix.  Consequently, animation speed has increased
//     by a factor of five or more.
//
// -*- Added SokoMatrixSquare, a subclass of SokoMatrix, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added SokoMatrixHexagon, a subclass of SokoMatrix, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#import <appkit/View.h>
#import "SokoPuzzle.h"
@class NXImage;

@interface SokoMatrix : View
    {
    int rows;
    int cols;
    NXImage** matrix;
    id delegate;
    }

+ (NXImage*)imageForCellType:(SokoCellType)type withRow:(int)r column:(int)c;
- (id)initWithRows:(int)r columns:(int)c;
- (id)free;
- (id)setDelegate:(id)d;
- (id)delegate;
- (void)drawCellAtRow:(int)r column:(int)c;
- (void)setCellType:(SokoCellType)type atRow:(int)r column:(int)c;
- (NXImage*)imageAtRow:(int)r column:(int)c;
- (BOOL)getRow:(int*)r column:(int*)c forPoint:(NXPoint const*)p;
- (BOOL)acceptsFirstResponder;
- (BOOL)acceptsFirstMouse;
- (id)mouseDown:(NXEvent*)e;
- (id)mouseUp:(NXEvent*)e;
- (id)mouseDragged:(NXEvent*)e;
- (id)rightMouseDown:(NXEvent*)e;
- (id)rightMouseUp:(NXEvent*)e;
- (id)rightMouseDragged:(NXEvent*)e;
- (id)keyDown:(NXEvent*)e;
- (id)keyUp:(NXEvent*)e;

@end

#endif // SokoMatrix_h
