//-----------------------------------------------------------------------------
// SokoInfo.m
//
//	Info panel object for SokoSave.
//
// Copyright (c), 1997,2001, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.m,v 1.3 2001/12/23 15:52:18 sunshine Exp $
// $Log: SokoInfo.m,v $
// Revision 1.3  2001/12/23 15:52:18  sunshine
// v15
// -*- Converted the documentation from RTFD format to HTML format.
//     Documentation is no longer embedded in a scrollable text object on the
//     Info panel.  Instead, a "Help" menu item now displays the help file
//     via a web browser.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  It handles mailto: URLs directly;
//     all others are handed off to OmniWeb's "Open URL" service.
//
// -*- Added SokoWindow and SokoPanel which are subclasses of Window and
//     Panel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  Although these
//     classes currently implement no extra functionality, they provide
//     convenient hooks for the addition of new functionality in the future,
//     if needed.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// Revision 1.2  2001/08/19 10:07:59  sunshine
// v11
// -*- Converted from Objective-C++ to pure Objective-C.  Changed file
//     extensions from .M to .m, and .cc to .c.  This change makes it easier
//     to support both GNUstep and MacOS/X, neither of which feature an
//     Objective-C++ compiler (though MacOS/X will reportedly support
//     Objective-C++ at some point in the future).
//
// -*- Eliminated all inclusions of <appkit/appkit.h> throughout the project;
//     replaced with inclusion of individual header files.
//
// -*- Added SokoHelp.rtfd which contains the user documentation which used to
//     reside directly within the SokoInfo.nib.  This documentation is now
//     loaded into the text section of the SokoInfo.nib from SokoHelp.rtfd at
//     run-time.
//
// -*- Added a "miniaturize" button to the Info panel.  Also now sets the
//     miniwindow icon for this panel.
//
// -*- Replaced uses of MAXPATHLEN with FILENAME_MAX from <stdio.h> so that
//     FILENAME_MAX is now used consistently throughout the project instead of
//     having a mixture of the two.
//
// -*- Renamed the following functions in order to avoid potential symbolic
//     collisions in the target environment:
//
//     basename --> soko_basename
//     collapse --> soko_collapse
//     directoryPart --> soko_directory_part
//     ends_with --> soko_ends_with
//     expand --> soko_expand
//     filenamePart --> soko_filename_part
//     getFactoryScoresFile --> soko_get_factory_scores_file
//     getMazeDirectory --> soko_get_maze_directory
//     getMazeExtension --> soko_get_maze_extension
//     getSaveDirectory --> soko_get_save_directory
//     getSaveExtension --> soko_get_save_extension
//     getScoresFile --> soko_get_scores_file
//     load_nib --> soko_load_nib
//     mazeNameForLevel --> soko_maze_name_for_level
//     mkdirs --> soko_mkdirs
//     runLengthDecodeChar --> soko_run_length_decode_char
//     runLengthDecodeString --> soko_run_length_decode_string
//     runLengthEncodeChar --> soko_run_length_encode_char
//     runLengthEncodeString --> soko_run_length_encode_string
//     saveFileNameForMazeName --> soko_save_filename_for_maze_name
//     starts_with --> soko_starts_with
//     strdup --> soko_strdup
//
// -*- Upgraded formatting of source and header files which I had not updated
//     in the last version.  Added explicit (id) in several places which had
//     not previously been updated.
//-----------------------------------------------------------------------------
#import "SokoInfo.h"
#import "SokoAssert.h"
#import "SokoDefs.h"
#import "SokoBuild.h"
#import "SokoRelease.h"
#import "SokoURL.h"
#import "SokoWindow.h"
#import <appkit/Application.h>
#import <appkit/NXImage.h>
#import <appkit/TextField.h>
#import <objc/NXBundle.h>

@implementation SokoInfo

//-----------------------------------------------------------------------------
// setField:value:append:
//-----------------------------------------------------------------------------
- (void)setField:(TextField*)field value:(char const*)value
    append:(BOOL)append
    {
    if (!append)
	[field setStringValue:value];
    else
	{
	char buff[ 256 ];
	sprintf( buff, "%s %s", [field stringValue], value );
	SOKO_ASSERT( strlen(buff) < sizeof(buff) );
	[field setStringValue:buff];
	}
    }


//-----------------------------------------------------------------------------
// setUrl:value:email:
//-----------------------------------------------------------------------------
- (void)setUrl:(SokoURL*)field value:(char const*)value email:(BOOL)email
    {
    int const n = strlen(value) + 32;
    char const* str_fmt = (email ? "<%s>" : "%s");
    char const* url_fmt = (email ? "mailto:%s" : "http://%s/");
    char* str = (char*)malloc( n * 2 );
    char* url = str + n;
    sprintf( str, str_fmt, value );
    sprintf( url, url_fmt, value );
    [field setStringValue:str url:url];
    free( str );
    }


//-----------------------------------------------------------------------------
// init
//-----------------------------------------------------------------------------
- (id)init
    {
    [super init];
    [NXApp loadNibSection:"SokoInfo.nib" owner:self withNames:NO];
    [panel setMiniwindowIcon:"SokoSave"];
    [panel center];
    [self setField:authorMcCarthy value:SOKO_AUTHOR_MCCARTHY append:NO ];
    [self setField:authorSunshine value:SOKO_AUTHOR_SUNSHINE append:NO ];
    [self setField:releaseField   value:SOKO_RELEASE         append:YES];
    [self setField:buildField     value:SOKO_BUILD           append:YES];
    [self setUrl:mailMcCarthy     value:SOKO_MAIL_MCCARTHY   email: YES];
    [self setUrl:mailSunshine     value:SOKO_MAIL_SUNSHINE   email: YES];
    [self setUrl:webPage          value:SOKO_WEB_PAGE        email: NO ];
    return self;
    }


//-----------------------------------------------------------------------------
// free
//-----------------------------------------------------------------------------
- (id)free
    {
    [panel setDelegate:0];
    [panel close];
    [panel free];
    return [super free];
    }


//-----------------------------------------------------------------------------
// startTracking
//-----------------------------------------------------------------------------
- (void)startTracking
    {
    [mailMcCarthy startTracking];
    [mailSunshine startTracking];
    [webPage startTracking];
    }


//-----------------------------------------------------------------------------
// stopTracking
//-----------------------------------------------------------------------------
- (void)stopTracking
    {
    [mailMcCarthy stopTracking];
    [mailSunshine stopTracking];
    [webPage stopTracking];
    }


//-----------------------------------------------------------------------------
// windowDidBecomeKey:
//-----------------------------------------------------------------------------
- (id)windowDidBecomeKey:(id)sender
    {
    [self startTracking];
    return self;
    }


//-----------------------------------------------------------------------------
// windowDidResignKey:
//-----------------------------------------------------------------------------
- (id)windowDidResignKey:(id)sender
    {
    [self stopTracking];
    return self;
    }


//-----------------------------------------------------------------------------
// windowWillClose:
//-----------------------------------------------------------------------------
- (id)windowWillClose:(id)sender
    {
    [self stopTracking];
    return self;
    }


//-----------------------------------------------------------------------------
// activate
//-----------------------------------------------------------------------------
- (void)activate
    {
    [panel makeKeyAndOrderFront:self];
    }


//-----------------------------------------------------------------------------
// launch
//-----------------------------------------------------------------------------
+ (void)launch
    {
    static id instance = 0;
    if (instance == 0)
	instance = [[self alloc] init];
    [instance activate];
    }

@end
