#ifndef SokoInfo_h
#define SokoInfo_h
//-----------------------------------------------------------------------------
// SokoInfo.h
//
//	Info panel object for SokoSave.
//
// Copyright (c), 1997,2001, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.h,v 1.3 2001/12/24 19:52:19 sunshine Exp $
// $Log: SokoInfo.h,v $
// Revision 1.3  2001/12/24 19:52:19  sunshine
// v15
// -*- Converted the documentation from RTFD format to HTML format.
//     Documentation is no longer embedded in a scrollable text object on the
//     Info panel.  Instead, a "Help" menu item now displays the help file
//     via a web browser.
//
// -*- Email addresses (and names) on Info panel are now active links which
//     launch the mail program.  The email addresses appears underlined as
//     the mouse flies over it.
//
// -*- Added a SokoSave URL to the Info panel.  The URL is an active link
//     which launches the web browser when clicked.  The URL appears
//     underlined as the mouse flies over it.
//
// -*- Added the SokoURL class for use by the Info panel.  This class
//     displays fly-over, clickable URLs.  It handles mailto: URLs directly;
//     all others are handed off to OmniWeb's "Open URL" service.
//
// -*- Added SokoWindow and SokoPanel which are subclasses of Window and
//     Panel, respectively.  All windows and panels throughout the
//     application are now instances of these classes.  Although these
//     classes currently implement no extra functionality, they provide
//     convenient hooks for the addition of new functionality in the future,
//     if needed.
//
// -*- Renamed "window" instance variable to "panel" for all classes and nibs
//     in which a panel is actually used (everything but SokoBoard, in fact).
//
// Revision 1.2  2001/08/19 10:07:53  sunshine
// v11
// -*- Converted from Objective-C++ to pure Objective-C.  Changed file
//     extensions from .M to .m, and .cc to .c.  This change makes it easier
//     to support both GNUstep and MacOS/X, neither of which feature an
//     Objective-C++ compiler (though MacOS/X will reportedly support
//     Objective-C++ at some point in the future).
//
// -*- Eliminated all inclusions of <appkit/appkit.h> throughout the project;
//     replaced with inclusion of individual header files.
//
// -*- Added SokoHelp.rtfd which contains the user documentation which used to
//     reside directly within the SokoInfo.nib.  This documentation is now
//     loaded into the text section of the SokoInfo.nib from SokoHelp.rtfd at
//     run-time.
//
// -*- Added a "miniaturize" button to the Info panel.  Also now sets the
//     miniwindow icon for this panel.
//
// -*- Replaced uses of MAXPATHLEN with FILENAME_MAX from <stdio.h> so that
//     FILENAME_MAX is now used consistently throughout the project instead of
//     having a mixture of the two.
//
// -*- Renamed the following functions in order to avoid potential symbolic
//     collisions in the target environment:
//
//     basename --> soko_basename
//     collapse --> soko_collapse
//     directoryPart --> soko_directory_part
//     ends_with --> soko_ends_with
//     expand --> soko_expand
//     filenamePart --> soko_filename_part
//     getFactoryScoresFile --> soko_get_factory_scores_file
//     getMazeDirectory --> soko_get_maze_directory
//     getMazeExtension --> soko_get_maze_extension
//     getSaveDirectory --> soko_get_save_directory
//     getSaveExtension --> soko_get_save_extension
//     getScoresFile --> soko_get_scores_file
//     load_nib --> soko_load_nib
//     mazeNameForLevel --> soko_maze_name_for_level
//     mkdirs --> soko_mkdirs
//     runLengthDecodeChar --> soko_run_length_decode_char
//     runLengthDecodeString --> soko_run_length_decode_string
//     runLengthEncodeChar --> soko_run_length_encode_char
//     runLengthEncodeString --> soko_run_length_encode_string
//     saveFileNameForMazeName --> soko_save_filename_for_maze_name
//     starts_with --> soko_starts_with
//     strdup --> soko_strdup
//
// -*- Upgraded formatting of source and header files which I had not updated
//     in the last version.  Added explicit (id) in several places which had
//     not previously been updated.
//-----------------------------------------------------------------------------
#import <objc/Object.h>
@class NXCursor, TextField, SokoPanel, SokoURL;

@interface SokoInfo : Object
    {
    SokoPanel* panel;
    TextField* authorMcCarthy;
    TextField* authorSunshine;
    SokoURL* mailMcCarthy;
    SokoURL* mailSunshine;
    SokoURL* webPage;
    TextField* releaseField;
    TextField* buildField;
    }

+ (void)launch;

@end

#endif // SokoInfo_h
