//-----------------------------------------------------------------------------
// SokoWrap.h
//
//	Utility macros which allow class definition in C and C++.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoWrap.h,v 1.2 2002/01/29 18:18:23 sunshine Exp $
// $Log: SokoWrap.h,v $
// Revision 1.2  2002/01/29 18:18:23  sunshine
// v17:
// -*- Added 6- and 7-argument macros variations.
//
// Revision 1.1  2001/12/21 21:55:34  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created wrappers for the new core game library so that it can be
//     accessed easily from C, Objective-C, and C++.
//-----------------------------------------------------------------------------
#if !defined(WR_INCLUDED) || \
    !defined(WR_DO_C)     || \
     defined(WR_DO_CPP)   || \
     defined(WR_DO_DELEGATE)
#define WR_INCLUDED
#include <stddef.h>

#define WR_PASTE_2(A,B)            WR_PASTE_HELPER_2(A,B)
#define WR_PASTE_3(A,B,C)          WR_PASTE_HELPER_3(A,B,C)
#define WR_PASTE_4(A,B,C,D)        WR_PASTE_HELPER_4(A,B,C,D)
#define WR_PASTE_HELPER_2(A,B)     A##B
#define WR_PASTE_HELPER_3(A,B,C)   A##B##C
#define WR_PASTE_HELPER_4(A,B,C,D) A##B##C##D

#undef  WR_METHOD
#define WR_METHOD(M) WR_PASTE_3(WR_CLASS,_,M)

#undef  WR_C_CLASS
#define WR_C_CLASS WR_PASTE_2(c,WR_CLASS)
#undef  WR_CLASS_STRUCT
#define WR_CLASS_STRUCT struct WR_PASTE_2(_,WR_CLASS)

#undef  WR_C_DELEGATE
#define WR_C_DELEGATE WR_PASTE_2(c,WR_DELEGATE)
#undef  WR_DELEGATE_STRUCT
#define WR_DELEGATE_STRUCT struct WR_PASTE_2(_,WR_DELEGATE)

#undef  WR_DELEGATE
#define WR_DELEGATE WR_PASTE_2(WR_CLASS,Delegate)
#undef  WR_DELEGATE_CALLBACK
#define WR_DELEGATE_CALLBACK(C) WR_PASTE_2(C,_callback)
#undef  WR_DELEGATE_INVOKE
#define WR_DELEGATE_INVOKE(C) WR_PASTE_2(invoke_,C)

#undef defclass
#undef endclass
#undef constructor0
#undef constructor1
#undef constructor2
#undef constructor3
#undef constructor4
#undef constructor5
#undef constructor6
#undef constructor7
#undef destructor
#undef method0
#undef method1
#undef method2
#undef method3
#undef method4
#undef method5
#undef method6
#undef method7
#undef methodv0
#undef methodv1
#undef methodv2
#undef methodv3
#undef methodv4
#undef methodv5
#undef methodv6
#undef methodv7
#undef methodd0
#undef methodd1
#undef methodd2
#undef methodd3
#undef methodd4
#undef methodd5
#undef methodd6
#undef methodd7
#undef factory0
#undef factory1
#undef factory2
#undef factory3
#undef factory4
#undef factory5
#undef factory6
#undef factory7
#undef factoryv0
#undef factoryv1
#undef factoryv2
#undef factoryv3
#undef factoryv4
#undef factoryv5
#undef factoryv6
#undef factoryv7
#undef factoryd0
#undef factoryd1
#undef factoryd2
#undef factoryd3
#undef factoryd4
#undef factoryd5
#undef factoryd6
#undef factoryd7
#undef factoryc0
#undef factoryc1
#undef factoryc2
#undef factoryc3
#undef factoryc4
#undef factoryc5
#undef factoryc6
#undef factoryc7

#undef defdelegate
#undef enddelegate
#undef callback0
#undef callback1
#undef callback2
#undef callback3
#undef callback4
#undef callback5
#undef callback6
#undef callback7
#undef callbackv0
#undef callbackv1
#undef callbackv2
#undef callbackv3
#undef callbackv4
#undef callbackv5
#undef callbackv6
#undef callbackv7

#if defined(WR_DO_DELEGATE)

#  define defclass
#  define endclass

#  define constructor0(NAME)
#  define constructor1(NAME,T1,A1)
#  define constructor2(NAME,T1,A1,T2,A2)
#  define constructor3(NAME,T1,A1,T2,A2,T3,A3)
#  define constructor4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define constructor5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define constructor6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define constructor7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define destructor(NAME)

#  define method0(RET,NAME)
#  define method1(RET,NAME,T1,A1)
#  define method2(RET,NAME,T1,A1,T2,A2)
#  define method3(RET,NAME,T1,A1,T2,A2,T3,A3)
#  define method4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define method5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define method6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define method7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define methodv0(NAME)
#  define methodv1(NAME,T1,A1)
#  define methodv2(NAME,T1,A1,T2,A2)
#  define methodv3(NAME,T1,A1,T2,A2,T3,A3)
#  define methodv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define methodv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define methodv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define methodv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define methodd0(NAME)
#  define methodd1(NAME,T1,A1)
#  define methodd2(NAME,T1,A1,T2,A2)
#  define methodd3(NAME,T1,A1,T2,A2,T3,A3)
#  define methodd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define methodd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define methodd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define methodd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define factory0(RET,NAME)
#  define factory1(RET,NAME,T1,A1)
#  define factory2(RET,NAME,T1,A1,T2,A2)
#  define factory3(RET,NAME,T1,A1,T2,A2,T3,A3)
#  define factory4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define factory5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define factory6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define factory7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define factoryv0(NAME)
#  define factoryv1(NAME,T1,A1)
#  define factoryv2(NAME,T1,A1,T2,A2)
#  define factoryv3(NAME,T1,A1,T2,A2,T3,A3)
#  define factoryv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define factoryv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define factoryv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define factoryv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define factoryd0(NAME)
#  define factoryd1(NAME,T1,A1)
#  define factoryd2(NAME,T1,A1,T2,A2)
#  define factoryd3(NAME,T1,A1,T2,A2,T3,A3)
#  define factoryd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define factoryd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define factoryd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define factoryd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define factoryc0(NAME)
#  define factoryc1(NAME,T1,A1)
#  define factoryc2(NAME,T1,A1,T2,A2)
#  define factoryc3(NAME,T1,A1,T2,A2,T3,A3)
#  define factoryc4(NAME,T1,A1,T2,A2,T3,A3,T4,A4)
#  define factoryc5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5)
#  define factoryc6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6)
#  define factoryc7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7)

#  define defdelegate inline WR_DELEGATE::WR_DELEGATE() {
#  define enddelegate info = 0; }

#  define callback0(RET,NAME) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback1(RET,NAME,T1,A1) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback2(RET,NAME,T1,A1,T2,A2) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callback7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);

#  define callbackv0(NAME) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv1(NAME,T1,A1) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv2(NAME,T1,A1,T2,A2) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);
#  define callbackv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_DELEGATE_CALLBACK(NAME) = WR_DELEGATE_INVOKE(NAME);

#elif defined(WR_DO_CPP)

#  undef  WR_DELEGATE_TYPE
#  define WR_DELEGATE_TYPE WR_DELEGATE*

#  define defclass \
     class WR_CLASS { private: WR_C_CLASS self; public: void* info;
#  define endclass \
     int instance_valid() const { return (self != 0); } \
     operator WR_C_CLASS() { return self; } };

#  define constructor0(NAME) \
     WR_CLASS::WR_CLASS(void* p=0): \
     info(p) { self = WR_METHOD(NAME)(this); }
#  define constructor1(NAME,T1,A1) \
     WR_CLASS::WR_CLASS(T1 A1,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,this); }
#  define constructor2(NAME,T1,A1,T2,A2) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,this); }
#  define constructor3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,T3 A3,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,A3,this); }
#  define constructor4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,T3 A3,T4 A4,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,A3,A4,this); }
#  define constructor5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,A3,A4,A5,this); }
#  define constructor6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,this); }
#  define constructor7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_CLASS::WR_CLASS(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7,void* p=0): \
     info(p) { self = WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,A7,this); }

#  define destructor(NAME) \
     WR_CLASS::~WR_CLASS() { if (self != 0) WR_METHOD(NAME)(self); }

#  define method0(RET,NAME) \
     RET NAME(void) \
     { return WR_METHOD(NAME)(self); }
#  define method1(RET,NAME,T1,A1) \
     RET NAME(T1 A1) \
     { return WR_METHOD(NAME)(self,A1); }
#  define method2(RET,NAME,T1,A1,T2,A2) \
     RET NAME(T1 A1,T2 A2) \
     { return WR_METHOD(NAME)(self,A1,A2); }
#  define method3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     RET NAME(T1 A1,T2 A2,T3 A3) \
     { return WR_METHOD(NAME)(self,A1,A2,A3); }
#  define method4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     RET NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { return WR_METHOD(NAME)(self,A1,A2,A3,A4); }
#  define method5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { return WR_METHOD(NAME)(self,A1,A2,A3,A4,A5); }
#  define method6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { return WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6); }
#  define method7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { return WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6,A7); }

#  define methodv0(NAME) \
     void NAME(void) \
     { WR_METHOD(NAME)(self); }
#  define methodv1(NAME,T1,A1) \
     void NAME(T1 A1) \
     { WR_METHOD(NAME)(self,A1); }
#  define methodv2(NAME,T1,A1,T2,A2) \
     void NAME(T1 A1,T2 A2) \
     { WR_METHOD(NAME)(self,A1,A2); }
#  define methodv3(NAME,T1,A1,T2,A2,T3,A3) \
     void NAME(T1 A1,T2 A2,T3 A3) \
     { WR_METHOD(NAME)(self,A1,A2,A3); }
#  define methodv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     void NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { WR_METHOD(NAME)(self,A1,A2,A3,A4); }
#  define methodv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { WR_METHOD(NAME)(self,A1,A2,A3,A4,A5); }
#  define methodv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6); }
#  define methodv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6,A7); }

#  define methodd0(NAME) \
     WR_DELEGATE_TYPE NAME(void) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self); }
#  define methodd1(NAME,T1,A1) \
     WR_DELEGATE_TYPE NAME(T1 A1) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1); }
#  define methodd2(NAME,T1,A1,T2,A2) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2); }
#  define methodd3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2,A3); }
#  define methodd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2,A3,A4); }
#  define methodd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2,A3,A4,A5); }
#  define methodd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6); }
#  define methodd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(self,A1,A2,A3,A4,A5,A6,A7); }

#  define factory0(RET,NAME) \
     static RET NAME(void) \
     { return WR_METHOD(NAME)(); }
#  define factory1(RET,NAME,T1,A1) \
     static RET NAME(T1 A1) \
     { return WR_METHOD(NAME)(A1); }
#  define factory2(RET,NAME,T1,A1,T2,A2) \
     static RET NAME(T1 A1,T2 A2) \
     { return WR_METHOD(NAME)(A1,A2); }
#  define factory3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     static RET NAME(T1 A1,T2 A2,T3 A3) \
     { return WR_METHOD(NAME)(A1,A2,A3); }
#  define factory4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     static RET NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { return WR_METHOD(NAME)(A1,A2,A3,A4); }
#  define factory5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     static RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { return WR_METHOD(NAME)(A1,A2,A3,A4,A5); }
#  define factory6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     static RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { return WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6); }
#  define factory7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     static RET NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { return WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,A7); }

#  define factoryv0(NAME) \
     static void NAME(void) \
     { WR_METHOD(NAME)(); }
#  define factoryv1(NAME,T1,A1) \
     static void NAME(T1 A1) \
     { WR_METHOD(NAME)(A1); }
#  define factoryv2(NAME,T1,A1,T2,A2) \
     static void NAME(T1 A1,T2 A2) \
     { WR_METHOD(NAME)(A1,A2); }
#  define factoryv3(NAME,T1,A1,T2,A2,T3,A3) \
     static void NAME(T1 A1,T2 A2,T3 A3) \
     { WR_METHOD(NAME)(A1,A2,A3); }
#  define factoryv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     static void NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { WR_METHOD(NAME)(A1,A2,A3,A4); }
#  define factoryv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     static void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { WR_METHOD(NAME)(A1,A2,A3,A4,A5); }
#  define factoryv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     static void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6); }
#  define factoryv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     static void NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,A7); }

#  define factoryd0(NAME) \
     static WR_DELEGATE_TYPE NAME(void) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(); }
#  define factoryd1(NAME,T1,A1) \
     static WR_DELEGATE_TYPE NAME(T1 A1) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1); }
#  define factoryd2(NAME,T1,A1,T2,A2) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2); }
#  define factoryd3(NAME,T1,A1,T2,A2,T3,A3) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2,A3); }
#  define factoryd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2,A3,A4); }
#  define factoryd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2,A3,A4,A5); }
#  define factoryd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6); }
#  define factoryd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     static WR_DELEGATE_TYPE NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { return (WR_DELEGATE_TYPE)WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,A7); }

#  define factoryc0(NAME) \
     static WR_CLASS* NAME(void) \
     { WR_C_CLASS c = WR_METHOD(NAME)(); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc1(NAME,T1,A1) \
     static WR_CLASS* NAME(T1 A1) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc2(NAME,T1,A1,T2,A2) \
     static WR_CLASS* NAME(T1 A1,T2 A2) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc3(NAME,T1,A1,T2,A2,T3,A3) \
     static WR_CLASS* NAME(T1 A1,T2 A2,T3 A3) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2,A3); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     static WR_CLASS* NAME(T1 A1,T2 A2,T3 A3,T4 A4) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2,A3,A4); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     static WR_CLASS* NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2,A3,A4,A5); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     static WR_CLASS* NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }
#  define factoryc7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     static WR_CLASS* NAME(T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
     { WR_C_CLASS c = WR_METHOD(NAME)(A1,A2,A3,A4,A5,A6,A7); \
     return (c == 0 ? 0 : (WR_CLASS*)(c->info)); }

#  define defdelegate class WR_CLASS; \
     class WR_DELEGATE : private WR_PASTE_2(_,WR_DELEGATE) {
#  define enddelegate public: friend WR_CLASS; \
     WR_DELEGATE(); virtual ~WR_DELEGATE() {} };

#  define callback0(RET,NAME) \
       public: virtual RET NAME(WR_CLASS*) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info)); }
#  define callback1(RET,NAME,T1,A1) \
       public: virtual RET NAME(WR_CLASS*,T1) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1); }
#  define callback2(RET,NAME,T1,A1,T2,A2) \
       public: virtual RET NAME(WR_CLASS*,T1,T2) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2); }
#  define callback3(RET,NAME,T1,A1,T2,A2,T3,A3) \
       public: virtual RET NAME(WR_CLASS*,T1,T2,T3) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3); }
#  define callback4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
       public: virtual RET NAME(WR_CLASS*,T1,T2,T3,T4) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4); }
#  define callback5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
       public: virtual RET NAME(WR_CLASS*,T1,T2,T3,T4,T5) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4,A5); }
#  define callback6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
       public: virtual RET NAME(WR_CLASS*,T1,T2,T3,T4,T5,T6) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*) \
       (C->info),A1,A2,A3,A4,A5,A6); }
#  define callback7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
       public: virtual RET NAME(WR_CLASS*,T1,T2,T3,T4,T5,T6,T7) = 0; \
       private: static RET WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D, \
       T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
       { return ((WR_DELEGATE*)D)->NAME((WR_CLASS*) \
       (C->info),A1,A2,A3,A4,A5,A6,A7); }

#  define callbackv0(NAME) \
       public: virtual void NAME(WR_CLASS*) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info)); }
#  define callbackv1(NAME,T1,A1) \
       public: virtual void NAME(WR_CLASS*,T1) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1); }
#  define callbackv2(NAME,T1,A1,T2,A2) \
       public: virtual void NAME(WR_CLASS*,T1,T2) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2); }
#  define callbackv3(NAME,T1,A1,T2,A2,T3,A3) \
       public: virtual void NAME(WR_CLASS*,T1,T2,T3) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3); }
#  define callbackv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
       public: virtual void NAME(WR_CLASS*,T1,T2,T3,T4) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4); }
#  define callbackv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
       public: virtual void NAME(WR_CLASS*,T1,T2,T3,T4,T5) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4,T5 A5) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4,A5); }
#  define callbackv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
       public: virtual void NAME(WR_CLASS*,T1,T2,T3,T4,T5,T6) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D,T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4,A5,A6); }
#  define callbackv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
       public: virtual void NAME(WR_CLASS*,T1,T2,T3,T4,T5,T6,T7) = 0; \
       private: static void WR_DELEGATE_INVOKE(NAME) \
       (WR_C_CLASS C,WR_C_DELEGATE D, \
       T1 A1,T2 A2,T3 A3,T4 A4,T5 A5,T6 A6,T7 A7) \
       { ((WR_DELEGATE*)D)->NAME((WR_CLASS*)(C->info),A1,A2,A3,A4,A5,A6,A7); }

#else

#  undef  WR_DELEGATE_TYPE
#  define WR_DELEGATE_TYPE WR_C_DELEGATE

#  undef WR_EXPORT
#  if defined(__cplusplus)
#    define WR_EXPORT(TYPE,NAME) extern "C" TYPE WR_METHOD(NAME)
#  else
#    define WR_EXPORT(TYPE,NAME) extern TYPE WR_METHOD(NAME)
#  endif

#  undef WR_C_ALIAS_CLASS
#  undef WR_C_ALIAS_DELEGATE
#  if defined(__cplusplus)
#    define WR_C_ALIAS_CLASS
#    define WR_C_ALIAS_DELEGATE
#  else
#    define WR_C_ALIAS_CLASS    typedef WR_C_CLASS    WR_CLASS;
#    define WR_C_ALIAS_DELEGATE typedef WR_C_DELEGATE WR_DELEGATE;
#  endif

#  define defclass \
     struct WR_PASTE_2(WR_CLASS,Data); \
     typedef WR_CLASS_STRUCT \
     { struct WR_PASTE_2(WR_CLASS,Data)* data; void* info; } \
     *WR_C_CLASS; WR_C_ALIAS_CLASS
#  define endclass

#  define constructor0(NAME) \
     WR_EXPORT(WR_C_CLASS,NAME)(void*);
#  define constructor1(NAME,T1,A1) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,void*);
#  define constructor2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,void*);
#  define constructor3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,void*);
#  define constructor4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,void*);
#  define constructor5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5,void*);
#  define constructor6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5,T6,void*);
#  define constructor7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5,T6,T7,void*);

#  define destructor(NAME) \
     WR_EXPORT(void,NAME)(WR_C_CLASS);

#  define method0(RET,NAME) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS);
#  define method1(RET,NAME,T1,A1) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1);
#  define method2(RET,NAME,T1,A1,T2,A2) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2);
#  define method3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2,T3);
#  define method4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2,T3,T4);
#  define method5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5);
#  define method6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6);
#  define method7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(RET,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6,T7);

#  define methodv0(NAME) \
     WR_EXPORT(void,NAME)(WR_C_CLASS);
#  define methodv1(NAME,T1,A1) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1);
#  define methodv2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2);
#  define methodv3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2,T3);
#  define methodv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2,T3,T4);
#  define methodv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5);
#  define methodv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6);
#  define methodv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(void,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6,T7);

#  define methodd0(NAME) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS);
#  define methodd1(NAME,T1,A1) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1);
#  define methodd2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2);
#  define methodd3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2,T3);
#  define methodd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2,T3,T4);
#  define methodd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5);
#  define methodd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6);
#  define methodd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(WR_C_CLASS,T1,T2,T3,T4,T5,T6,T7);

#  define factory0(RET,NAME) \
     WR_EXPORT(RET,NAME)(void);
#  define factory1(RET,NAME,T1,A1) \
     WR_EXPORT(RET,NAME)(T1);
#  define factory2(RET,NAME,T1,A1,T2,A2) \
     WR_EXPORT(RET,NAME)(T1,T2);
#  define factory3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(RET,NAME)(T1,T2,T3);
#  define factory4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(RET,NAME)(T1,T2,T3,T4);
#  define factory5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(RET,NAME)(T1,T2,T3,T4,T5);
#  define factory6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(RET,NAME)(T1,T2,T3,T4,T5,T6);
#  define factory7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(RET,NAME)(T1,T2,T3,T4,T5,T6,T7);

#  define factoryv0(NAME) \
     WR_EXPORT(void,NAME)(void);
#  define factoryv1(NAME,T1,A1) \
     WR_EXPORT(void,NAME)(T1);
#  define factoryv2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(void,NAME)(T1,T2);
#  define factoryv3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(void,NAME)(T1,T2,T3);
#  define factoryv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(void,NAME)(T1,T2,T3,T4);
#  define factoryv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(void,NAME)(T1,T2,T3,T4,T5);
#  define factoryv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(void,NAME)(T1,T2,T3,T4,T5,T6);
#  define factoryv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(void,NAME)(T1,T2,T3,T4,T5,T6,T7);

#  define factoryd0(NAME) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(void);
#  define factoryd1(NAME,T1,A1) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1);
#  define factoryd2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2);
#  define factoryd3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2,T3);
#  define factoryd4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2,T3,T4);
#  define factoryd5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2,T3,T4,T5);
#  define factoryd6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2,T3,T4,T5,T6);
#  define factoryd7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(WR_DELEGATE_TYPE,NAME)(T1,T2,T3,T4,T5,T6,T7);

#  define factoryc0(NAME) \
     WR_EXPORT(WR_C_CLASS,NAME)(void);
#  define factoryc1(NAME,T1,A1) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1);
#  define factoryc2(NAME,T1,A1,T2,A2) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2);
#  define factoryc3(NAME,T1,A1,T2,A2,T3,A3) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3);
#  define factoryc4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4);
#  define factoryc5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5);
#  define factoryc6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5,T6);
#  define factoryc7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     WR_EXPORT(WR_C_CLASS,NAME)(T1,T2,T3,T4,T5,T6,T7);

#  define defdelegate \
     WR_CLASS_STRUCT; \
     WR_DELEGATE_STRUCT; \
     typedef WR_DELEGATE_STRUCT* WR_C_DELEGATE; \
     WR_C_ALIAS_DELEGATE \
     WR_DELEGATE_STRUCT {
#  define enddelegate void* info; };

#  define callback0(RET,NAME) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE);
#  define callback1(RET,NAME,T1,A1) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1);
#  define callback2(RET,NAME,T1,A1,T2,A2) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2);
#  define callback3(RET,NAME,T1,A1,T2,A2,T3,A3) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3);
#  define callback4(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4);
#  define callback5(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5);
#  define callback6(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5,T6);
#  define callback7(RET,NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     RET (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5,T6,T7);

#  define callbackv0(NAME) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE);
#  define callbackv1(NAME,T1,A1) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1);
#  define callbackv2(NAME,T1,A1,T2,A2) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2);
#  define callbackv3(NAME,T1,A1,T2,A2,T3,A3) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3);
#  define callbackv4(NAME,T1,A1,T2,A2,T3,A3,T4,A4) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4);
#  define callbackv5(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5);
#  define callbackv6(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5,T6);
#  define callbackv7(NAME,T1,A1,T2,A2,T3,A3,T4,A4,T5,A5,T6,A6,T7,A7) \
     void (*WR_DELEGATE_CALLBACK(NAME)) \
     (WR_CLASS_STRUCT*,WR_C_DELEGATE,T1,T2,T3,T4,T5,T6,T7);

#endif

#define WR_DO_C
#if defined(WR_DO_DELEGATE)
#  undef  WR_DO_C
#  undef  WR_DO_CPP
#  undef  WR_DO_DELEGATE
#elif defined(WR_DO_CPP)
#  undef  WR_DO_C
#  define WR_DO_DELEGATE
#elif defined(__cplusplus)
#  define WR_DO_CPP
#endif

#endif
