#ifndef SokoUtil_h
#define SokoUtil_h
//-----------------------------------------------------------------------------
// SokoUtil.h
//
//	Utility routines for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoUtil.h,v 1.4 2002/01/29 18:19:50 sunshine Exp $
// $Log: SokoUtil.h,v $
// Revision 1.4  2002/01/29 18:19:50  sunshine
// v17:
// -*- Added soko_extension_part() to SokoUtil.
//
// -*- Added soko_read_line_terminator() to SokoUtil.  Unlike
//     soko_read_line() which always null-terminates the returned string even
//     if the input line would have overflowed the buffer, this function
//     allows control over the termination.
//
// Revision 1.3  2001/12/23 00:21:41  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Augmented all input/output logic so that it now deals gracefully with
//     line terminators from all common platforms; Unix (LF), Macintosh (CR),
//     and Windows/DOS (CRLF).
//
// -*- Added soko_collapse() to SokoUtil.  This function trims leading and
//     trailing whitespace from a string and collapses all internal
//     whitespace to a single space.
//
// -*- Added soko_trim(), soko_ltrim() and soko_rtrim() to SokoUtil.
//
// -*- Added portable soko_stricmp() and soko_strnicmp() to replace
//     non-portable use of strcasecmp() and/or stricmp().
//
// -*- Renamed soko_starts_with() and soko_ends_with() to soko_has_prefix()
//     and soko_has_suffix(), respectively.  Also added an input flag which
//     controls case-sensitivity of these functions.
//
// -*- Added soko_normalize_path() and soko_denormalize_path() to SokoUtil.
//     All path manipulation functions now utilize these functions in order
//     to ensure correctness of path parsing and composition on all
//     platforms.
//
// -*- Moved soko_filename_part(), soko_directory_part(), soko_basename(),
//     and soko_mkdir() from SokoFile to SokoUtil.  Augmented these functions
//     so that they work correctly with pathnames from Unix, Macintosh, and
//     Windows (including Microsoft's UNC-style pathnames).
//
// -*- Added soko_add_path_component(), soko_add_path_extension(),
//     soko_replace_path_extension(), soko_remove_path_extension(), and
//     soko_path_exists() to SokoUtil.  These functions deal correctly with
//     pathnames from Unix, Macintosh, and Windows (including Microsoft's
//     UNC-style pathnames).
//
// -*- Added soko_readline() to SokoUtil.  This function is a replacement for
//     fgets().  It correctly handles Unix (LF), Macintosh (CR), and
//     Windows/DOS (CRLF) line terminators.
//-----------------------------------------------------------------------------
#include "SokoDefs.h"
SOKO_EXTERN_C_OPEN
#include <stdio.h>
SOKO_EXTERN_C_CLOSE

soko_export char* soko_strdup( char const* s );
soko_export char const* soko_collapse( cSokoPool, char const* s );
soko_export char const* soko_trim( cSokoPool, char const* s );
soko_export char const* soko_ltrim( cSokoPool, char const* s );
soko_export char const* soko_rtrim( cSokoPool, char const* s );
soko_export int soko_stricmp( char const* s1, char const* s2 );
soko_export int soko_strnicmp( char const* s1, char const* s2, size_t n );
soko_export soko_bool soko_has_prefix(
    char const* str, char const* pfx, soko_bool ignore_case );
soko_export soko_bool soko_has_suffix(
    char const* str, char const* sfx, soko_bool ignore_case );

soko_export char const* soko_normalize_path( cSokoPool, char const* path );
soko_export char const* soko_denormalize_path( cSokoPool, char const* path );
soko_export char const* soko_directory_part( cSokoPool, char const* path );
soko_export char const* soko_filename_part( cSokoPool, char const* path );
soko_export char const* soko_extension_part( cSokoPool, char const* path );
soko_export char const* soko_basename(
    cSokoPool, char const* path, char const* suffix );
soko_export char const* soko_add_path_component(
    cSokoPool, char const* path, char const* component );
soko_export char const* soko_add_path_extension(
    cSokoPool, char const* path, char const* extension );
soko_export char const* soko_replace_path_extension(
    cSokoPool, char const* path, char const* ext );
soko_export char const* soko_remove_path_extension(
    cSokoPool, char const* path );

soko_export soko_bool soko_path_exists( cSokoPool, char const* path );
soko_export soko_bool soko_mkdirs( cSokoPool, char const* path );
soko_export int soko_read_line( FILE* file, char* buffer, int bufer_size );
soko_export int soko_read_line_terminate(
    FILE* file, char* buffer, int buffer_size, soko_bool terminate );

#endif // SokoUtil_h
