#if !defined(SokoSetting_h) || defined(SokoSetting_cplusplus)
#define SokoSetting_h
#if defined(__cplusplus) && !defined(SokoSetting_cplusplus)
#define SokoSetting_cplusplus
#include __FILE__
#include __FILE__
#undef  SokoSetting_cplusplus
#endif
//-----------------------------------------------------------------------------
// SokoSetting.h
//
//	User-specific persistent settings.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoSetting.h,v 1.1 2001/12/21 22:03:52 sunshine Exp $
// $Log: SokoSetting.h,v $
// Revision 1.1  2001/12/21 22:03:52  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//
//-----------------------------------------------------------------------------
#include "SokoWrap.h"
#include "SokoDefs.h"

#define WR_CLASS SokoSetting

defdelegate
    callback1(soko_bool, exists, char const*,name)
    callback2(char const*, get, char const*,name, cSokoPool,pool)
    callbackv2(set, char const*,name, char const*,value)
    callbackv1(remove, char const*,name)
    callback1(char const*, factory_path, cSokoPool,pool) /* $(SokoSave) */
    callback1(char const*, user_path, cSokoPool,pool)    /* $(SokoUser) */
enddelegate

defclass
    factoryv1(set_delegate, WR_DELEGATE_TYPE,delegate)
    factoryd0(get_delegate);
    constructor0(new)
    destructor(destroy)
    method3(char const*, get_string, char const*,name, char const*,fallback,
	cSokoPool,pool)
    methodv2(set_string, char const*,name, char const*,value)
    method2(soko_bool, get_bool, char const*,name, soko_bool,fallback)
    methodv2(set_bool, char const*,name, soko_bool,value)
    method2(int, get_int, char const*,name, int,fallback)
    methodv2(set_int, char const*,name, int,value)
    method2(float, get_float, char const*,name, float,fallback)
    methodv2(set_float, char const*,name, float,value)
    method1(soko_bool, exists, char const*,name)
    methodv1(remove, char const*,name)
    method1(char const*, factory_path, cSokoPool,pool)
    method1(char const*, user_path, cSokoPool,pool)
endclass

#undef WR_CLASS

#endif
