#if !defined(SokoScore_h) || defined(SokoScore_cplusplus)
#define SokoScore_h
#if defined(__cplusplus) && !defined(SokoScore_cplusplus)
#define SokoScore_cplusplus
#include __FILE__
#include __FILE__
#undef  SokoScore_cplusplus
#endif
//-----------------------------------------------------------------------------
// SokoScore.h
//
//	High score management for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoScore.h,v 1.4 2002/01/29 18:37:27 sunshine Exp $
// $Log: SokoScore.h,v $
// Revision 1.4  2002/01/29 18:37:27  sunshine
// v17:
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- SokoScore now records "runs" and "focus" scores in SCORES file.
//
// Revision 1.3  2001/12/23 00:29:00  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Augmented all input/output logic so that it now deals gracefully with
//     line terminators from all common platforms; Unix (LF), Macintosh (CR),
//     and Windows/DOS (CRLF).
//
// -*- For safety, SCORES is now written out immediately after a new score is
//     recorded, rather than only at program termination time.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- SokoScore now trims and collapses strings before recording them in the
//     score table.
//-----------------------------------------------------------------------------
#include "SokoWrap.h"
#include "SokoDefs.h"

#if defined(WR_DO_C)

typedef enum
    {
    SOKO_SCORE_PUZZLE,
    SOKO_SCORE_MOVES,
    SOKO_SCORE_PUSHES,
    SOKO_SCORE_DATE,
    SOKO_SCORE_PLAYER,
    SOKO_SCORE_NOTES,
    SOKO_SCORE_RUNS,
    SOKO_SCORE_FOCUS
    } SokoScoreSort;
#define SOKO_SCORE_MAX (SOKO_SCORE_FOCUS + 1)

typedef struct _SokoHighScore
    {
    char const* puzzle;
    int moves;
    int pushes;
    int runs;
    int focus;
    unsigned long date; // Seconds since Epoch; return value of time();
    char const* date_formatted;
    char const* player;
    char const* notes;
    } SokoHighScore;

#endif

#define WR_CLASS SokoScore

defdelegate
    callbackv3(alert, SokoAlert,severity, char const*,title, char const*,msg)
enddelegate

defclass
    constructor1(new, WR_DELEGATE_TYPE,delegate)
    destructor(destroy)
    methodd0(get_delegate)
    method0(int, score_count)
    method1(SokoHighScore const*, get_score, int,record)
    method1(SokoHighScore const*, get_all_scores_unsorted, int*,score_count)
    methodv2(sort, SokoScoreSort const*,criteria, int,criteria_count)
    method7(int, add, cSokoPuzzle,puzzle, int,moves, int,pushes, int,runs,
	int,focus, char const*,player, char const*,notes)
endclass

#undef WR_CLASS

#endif // SokoScore_h
