#if !defined(SokoPuzzle_h) || defined(SokoPuzzle_cplusplus)
#define SokoPuzzle_h
#if defined(__cplusplus) && !defined(SokoPuzzle_cplusplus)
#define SokoPuzzle_cplusplus
#include __FILE__
#include __FILE__
#undef  SokoPuzzle_cplusplus
#endif
//-----------------------------------------------------------------------------
// SokoPuzzle.h
//
//	Object representing a single puzzle instance.
//
// Copyright (c), 1997,2001,2002 Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPuzzle.h,v 1.6 2002/02/19 07:35:34 sunshine Exp $
// $Log: SokoPuzzle.h,v $
// Revision 1.6  2002/02/19 07:35:34  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- SokoPuzzle now maintains the raw meta-data from the puzzle file rather
//     than merely ignoring it.  Clients may access the raw data via the new
//     SokoPuzzle meta_data() method.
//
// -*- SokoPuzzle now parses a puzzle's meta-data and builds a list of
//     key/value tuples from it.  The tuples are extracted from lines which
//     resemble "Keyword: value", optionally preceded by any number of
//     semi-colons (`;') since many existing puzzle sets use this format.
//     Clients may look up keywords (case insensitive) or retrieve the entire
//     list of key/value tuples.
//
// -*- Consolidated the user-interface movement constraints into SokoPuzzle
//     rather than having the same code repeated in each port.  This code
//     decides whether or not the direction movement buttons in the
//     user-interface should be enabled depending upon cell type,
//     orientation, etc.  Added the SokoPuzzle methods can_move_constrained()
//     and can_move_diagonal_constrained() to complement the existing
//     can_move() and can_move_diagonal().
//
// Revision 1.5  2002/01/29 18:50:03  sunshine
// v17:
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer fills areas outside the puzzle with wall segments.  Doing so
//     causes some "artistic" effect to be lost from some puzzles.  Added
//     SokoCellType SOKO_CELL_NULL to support of this.
//
// -*- Made puzzle parser sufficiently robust to determine whether a
//     hexagonal puzzle is using the conventional even-on-even/odd-on-odd
//     rule or the unconventional even-on-odd/odd-on-even rule.  Since there
//     is an chance that puzzle designers will not follow convention, it is
//     safest to recognize both styles and adjust dynamically.
//
// -*- Added SokoPuzzleStyle enumeration to SokoPuzzle.  Styles are
//     SOKO_STYLE_SQUARE and SOKO_STYLE_HEXAGON.
//
// -*- Now recognize these additional file extensions: .xsb, .hsb, .sokohex.
//
// -*- Removed soko_get_puzzle_extension() and soko_get_save_extension() from
//     SokoFile.
//
// -*- Relocated functionality of soko_save_filename_for_puzzle(),
//     soko_puzzle_name_for_level(), and soko_level_for_puzzle_name() from
//     SokoFile to SokoPuzzle, where they are class methods of SokoPuzzle.
//
// -*- Added get_puzzle_extensions(), get_puzzle_extensions_count(), and
//     get_save_extension() as class methods to SokoPuzzle.  There are now
//     multiple recognized puzzle extensions, rather than just the one
//     (.sokomaze).
//
// -*- Added file_is_puzzle(), file_is_save_game(), and get_file_style()
//     class methods to SokoPuzzle.
//
// -*- As an interim step to full puzzle-set support, the puzzle loader now
//     ignores comment lines in files (such as those in many .xsb files).  A
//     comment is defined as a line that begins with any non-puzzle character
//     (with optional leading whitespace).
//
// -*- Extended keyboard movement support.  Numeric keypad can now be used,
//     as well as standard arrow keys.  Added key equivalents for hexagonal
//     puzzles.
//
// -*- Augmented the behavior of the "Animate" switch so that it now controls
//     all animation, rather than only controlling animation of lengthy
//     playback sessions, which was the case previously.
//
// -*- For consistency, point-and-click crate movement now falls into
//     crate-drag mode, just as point-and-click player movement falls into
//     player drag mode.
//
// -*- Removed unused CELL_HEIGHT and CELL_WIDTH constants from SokoPuzzle.c.
//
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Now records "runs" and "focus" scores in save file.
//
// -*- Now records puzzle-style ("square" or "hexagon") in save file.
//
// -*- The following pieces of information are no longer recorded in the save
//     file since they can be derived automatically from other recorded data:
//     history-max, current-move-count, current-push-count, puzzle-height,
//     puzzle-width.
//
// -*- No longer compresses the history or the puzzle representation in the
//     save file.
//
// -*- Now uses the original puzzle tokens to encode the puzzle in the save
//     files rather than the internal SokoPuzzle tokens.  This means that the
//     puzzle representation in the save file is now human-readable.
//
// -*- Bumped the save file version number to 2 in response to all the
//     changes to the save file format.  (Still capable of reading version 1
//     files.)
//
// -*- Broke down and rewrote the save-file parser in order to simplify and
//     modularize it.  (It was getting far too complex in its old monolithic
//     form.)
//
// -*- Parser of version 1 saved puzzles now transforms unreachable tiles to
//     "empty" at load time.  This gives version 1 saved games an appearance
//     consistent with newer games (where empty space surrounding the puzzle
//     is left empty), rather than using the old appearance where all
//     unreachable tiles were marked as walls.
//
// -*- Fixed bug in handling of "best" move/push count in save file.  Was
//     incorrectly updating both numbers even if only one was bettered.  For,
//     for example, if a game had "best" counts of 100/10, and player
//     achieved 90/20, then "best" counts of 90/20 would be recorded, even
//     though they should have been 90/10.
//-----------------------------------------------------------------------------
#include "SokoWrap.h"
#include "SokoDefs.h"

#if defined(WR_DO_C)

typedef enum
    {
    SOKO_STYLE_SQUARE,
    SOKO_STYLE_HEXAGON,
    SOKO_STYLE_TRIANGLE
    } SokoPuzzleStyle;
#define SOKO_STYLE_MAX (SOKO_STYLE_TRIANGLE + 1)

typedef enum
    {
    SOKO_CELL_EMPTY,
    SOKO_CELL_EMPTY_SAFE,
    SOKO_CELL_WALL,
    SOKO_CELL_PLAYER,
    SOKO_CELL_PLAYER_SAFE,
    SOKO_CELL_CRATE,
    SOKO_CELL_CREATE_SAFE,
    SOKO_CELL_CRATE_SELECTED,
    SOKO_CELL_CRATE_SELECTED_SAFE,
    SOKO_CELL_NULL
    } SokoCellType;
#define SOKO_CELL_MAX (SOKO_CELL_NULL + 1)

typedef enum
    {
    SOKO_DIR_UP,
    SOKO_DIR_LEFT,
    SOKO_DIR_RIGHT,
    SOKO_DIR_DOWN,
    SOKO_DIR_NORTH,
    SOKO_DIR_SOUTH
    } SokoDirection;
#define SOKO_DIR_MAX (SOKO_DIR_SOUTH + 1)

typedef enum
    {
    SOKO_DIAG_UP_LEFT,
    SOKO_DIAG_UP_RIGHT,
    SOKO_DIAG_DOWN_LEFT,
    SOKO_DIAG_DOWN_RIGHT
    } SokoDiagonal;
#define SOKO_DIAG_MAX (SOKO_DIAG_DOWN_RIGHT + 1)

typedef enum
    {
    SOKO_KEY_UP,
    SOKO_KEY_DOWN,
    SOKO_KEY_LEFT,
    SOKO_KEY_RIGHT,
    SOKO_KEY_UP_LEFT,
    SOKO_KEY_UP_RIGHT,
    SOKO_KEY_DOWN_LEFT,
    SOKO_KEY_DOWN_RIGHT,
    SOKO_KEY_ESCAPE
    } SokoKeyCode;
#define SOKO_KEY_MAX (SOKO_KEY_ESCAPE + 1)

typedef unsigned long SokoEventFlags;
enum
    {
    SOKO_FLAG_SHIFT     = 1 << 0,
    SOKO_FLAG_CONTROL   = 1 << 1,
    SOKO_FLAG_ALTERNATE = 1 << 2,
    SOKO_FLAG_COMMAND   = 1 << 3
    };
#define SOKO_FLAG_ALL ((SokoEventFlags)~0)

typedef struct _SokoCell
    {
    int row;
    int col;
    SokoCellType type;
    } SokoCell;

typedef struct _SokoPuzzleExtension
    {
    char const* extension;
    SokoPuzzleStyle style;
    } SokoPuzzleExtension;

#endif

#define WR_CLASS SokoPuzzle

defdelegate
    callbackv3(alert, SokoAlert,severity, char const*,title, char const*,msg)
    callbackv4(record_score, int,moves, int,pushes, int,runs, int,focus)
    callbackv1(record_level, int,level)
    callbackv1(set_solved, soko_bool,solved)
    callbackv1(set_dirty, soko_bool,dirty)
    callbackv0(refresh_controls)
    callbackv0(refresh_all_cells)
    callbackv2(refresh_cells, SokoCell const*,dirty_list, int,dirty_count)
    callback0(soko_bool, should_animate_playback)
    callback0(int, playback_threshold)
    callbackv0(begin_playback)
    callbackv0(end_playback)
    callbackv0(begin_animation)
    callbackv0(end_animation)
    callbackv0(begin_drag)
    callbackv0(end_drag)
    callbackv1(process_events, soko_bool,await_event)
enddelegate

defclass
    factoryc1(find_open_puzzle, char const*,path)
    factoryc1(get_open_puzzle, int,n)
    factory0(int, open_puzzle_count)
    factoryv0(save_all_puzzles)
    factory0(SokoPuzzleExtension const*, get_puzzle_extensions)
    factory0(int, get_puzzle_extensions_count)
    factory0(char const*, get_save_extension)
    factory1(char const*, get_style_name, SokoPuzzleStyle,style)
    factory1(soko_bool, file_is_puzzle, char const*,path)
    factory1(soko_bool, file_is_save_game, char const*,path)
    factory1(SokoPuzzleStyle, get_file_style, char const*,path)
    factory2(char const*, save_name_for_puzzle_name, char const*,puzzle,
	cSokoPool,pool)
    factory2(char const*, puzzle_name_for_level, int,level, cSokoPool,pool)
    factory1(int, level_for_puzzle_name, char const*,path)
    constructor2(new, WR_DELEGATE_TYPE,delegate, char const*,path)
    destructor(destroy)
    methodd0(get_delegate)
    methodv1(reenact_history, int,target)
    methodv0(undo_move)
    methodv0(redo_move)
    methodv0(undo_push)
    methodv0(redo_push)
    methodv3(key_action,SokoKeyCode,code, soko_bool,down, SokoEventFlags,flags)
    methodv5(mouse_action, int,button, soko_bool,down, SokoEventFlags,flags,
	int,row, int,col)
    methodv2(mouse_drag, int,row, int,col)
    method1(soko_bool, move, SokoDirection,dir)
    method1(soko_bool, move_diagonal, SokoDiagonal,dir)
    method1(soko_bool, can_move, SokoDirection,dir)
    method1(soko_bool, can_move_constrained, SokoDirection,dir)
    method1(soko_bool, can_move_diagonal, SokoDiagonal,dir)
    method1(soko_bool, can_move_diagonal_constrained, SokoDiagonal,dir)
    method0(int, row_count)
    method0(int, col_count)
    method0(int, move_count)
    method0(int, push_count)
    method0(int, run_count)
    method0(int, focus_count)
    method0(int, history_position)
    method0(int, history_length)
    method0(int, player_row)
    method0(int, player_col)
    method0(int, selected_row)
    method0(int, selected_col)
    method1(char const*, get_puzzle_file_name, cSokoPool,pool)
    method1(char const*, get_save_file_name, cSokoPool,pool)
    method2(SokoCellType, cell_type, int,row, int,col)
    method0(soko_bool, drag_active)
    method0(soko_bool, animation_active)
    method0(soko_bool, playback_active)
    methodv0(advance_playback)
    methodv0(abort_playback)
    method0(SokoPuzzleStyle, puzzle_style)
    method0(soko_bool, puzzle_solved)
    method0(soko_bool, puzzle_dirty)
    method0(soko_bool, save)
    method0(soko_bool, save_if_dirty)
    method1(soko_bool, save_as, char const*,path)
    method0(char const*, meta_data)
    method1(char const*, meta_data_lookup, char const*,key)
    method0(int, meta_data_key_count)
    method1(char const*, meta_data_get_key, int,record)
    method1(char const*, meta_data_get_value, int,record)
endclass

#undef WR_CLASS

#endif // SokoPuzzle_h
