#if !defined(SokoPool_h) || defined(SokoPool_cplusplus)
#define SokoPool_h
#if defined(__cplusplus) && !defined(SokoPool_cplusplus)
#define SokoPool_cplusplus
#include __FILE__
#include __FILE__
#undef  SokoPool_cplusplus
#endif
//-----------------------------------------------------------------------------
// SokoPool.h
//
//	Memory pool object.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPool.h,v 1.1 2001/12/21 21:57:38 sunshine Exp $
// $Log: SokoPool.h,v $
// Revision 1.1  2001/12/21 21:57:38  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Added SokoPool which is a memory pool object.  This is used heavily by
//     the string manipulation functions in SokoUtil to ensure that composed
//     pathnames and strings do not go out of scope before the client is
//     finished with them.  This replaces the old statically allocated,
//     circular array of pathname buffers which was used in the past.
//
//-----------------------------------------------------------------------------
#include "SokoWrap.h"
#include "SokoDefs.h"

#define WR_CLASS SokoPool

defclass
    constructor0(new)
    destructor(destroy)
    method1(char*, allocate, unsigned long,nbytes)
    method1(char const*, store, char const*,string)
    method2(char const*, store_data, char const*,data, unsigned long,nbytes)
    method2(char const*, store_data_and_terminate, char const*,data,
	unsigned long,nbytes)
endclass

#undef WR_CLASS

#endif // SokoPool_h
