#ifndef SokoGeometry_h
#define SokoGeometry_h
//-----------------------------------------------------------------------------
// SokoGeometry.h
//
//	Geometric utility routines for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGeometry.h,v 1.1 2002/02/19 09:52:47 sunshine Exp $
// $Log: SokoGeometry.h,v $
// Revision 1.1  2002/02/19 09:52:47  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
//-----------------------------------------------------------------------------
#include "SokoDefs.h"

soko_export soko_bool soko_hit_test_square(
    int x,
    int y,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int origin_x,
    int origin_y,
    int* r,
    int* c );

soko_export void soko_coverage_square(
    int x,
    int y,
    int width,
    int height,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int origin_x,
    int origin_y,
    int* r,
    int* c,
    int* nr,
    int* nc );

soko_export soko_bool soko_hit_test_hexagon(
    int x,
    int y,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int cell_x_inset,
    int cell_y_inset,
    int origin_x,
    int origin_y,
    int* r,
    int* c );

soko_export void soko_coverage_hexagon(
    int x,
    int y,
    int width,
    int height,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int cell_x_inset,
    int cell_y_inset,
    int origin_x,
    int origin_y,
    int* r,
    int* c,
    int* nr,
    int* nc );

soko_export soko_bool soko_hit_test_triangle(
    int x,
    int y,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int cell_half_width,
    int origin_x,
    int origin_y,
    int* r,
    int* c );

soko_export void soko_coverage_triangle(
    int x,
    int y,
    int width,
    int height,
    int rows,
    int cols,
    int cell_width,
    int cell_height,
    int cell_half_width,
    int origin_x,
    int origin_y,
    int* r,
    int* c,
    int* nr,
    int* nc );

#endif // SokoGeometry_h
