#ifndef SokoFile_h
#define SokoFile_h
//-----------------------------------------------------------------------------
// SokoFile.h
//
//	Utility routines for manipulating filenames.
//
// Copyright (c), 1997,2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoFile.h,v 1.4 2002/01/29 18:22:13 sunshine Exp $
// $Log: SokoFile.h,v $
// Revision 1.4  2002/01/29 18:22:13  sunshine
// v17:
// -*- Removed soko_get_puzzle_extension() and soko_get_save_extension() from
//     SokoFile.
//
// -*- Relocated functionality of soko_save_filename_for_puzzle(),
//     soko_puzzle_name_for_level(), and soko_level_for_puzzle_name() from
//     SokoFile to SokoPuzzle, where they are class methods of SokoPuzzle.
//
// Revision 1.3  2001/12/23 00:36:56  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Replaced the terminology "maze" with "puzzle" throughout the project,
//     including source code, documentation, and all user-visible UI
//     elements.  The only remaining place where "maze" is still used is in
//     the file extension ".sokomaze".  I haven't decided what, if anything,
//     to do about that, yet.
//
// -*- Added the new pseudo-variable $(SokoUser) which points at the user's
//     "personal" file space.  This is where user-specific SokoSave files are
//     stored by default.  This variable complements the existing $(SokoSave)
//     variable.
//
// -*- Added SokoPool which is a memory pool object.  This is used heavily by
//     the string manipulation functions in SokoUtil to ensure that composed
//     pathnames and strings do not go out of scope before the client is
//     finished with them.  This replaces the old statically allocated,
//     circular array of pathname buffers which was used in the past.
//
// -*- Renamed soko_collapse() to soko_collapse_path().  Renamed
//     soko_expand() to soko_expand_path().
//
// -*- The path setting functions in SokoFile now invoke soko_collapse_path()
//     on all set operations.  This ensures that all paths displayed on the
//     preferences panel are properly collapsed, and removes the onus of this
//     task from the UI code.  Previously, soko_collapse_path() was only
//     called by the UI code for the puzzle path.
//
// -*- Added soko_normalize_path() and soko_denormalize_path() to SokoUtil.
//     All path manipulation functions now utilize these functions in order
//     to ensure correctness of path parsing and composition on all
//     platforms.
//
// -*- Moved soko_filename_part(), soko_directory_part(), soko_basename(),
//     and soko_mkdir() from SokoFile to SokoUtil.  Augmented these functions
//     so that they work correctly with pathnames from Unix, Macintosh, and
//     Windows (including Microsoft's UNC-style pathnames).
//
// -*- Added soko_add_path_component(), soko_add_path_extension(),
//     soko_replace_path_extension(), soko_remove_path_extension(), and
//     soko_path_exists() to SokoUtil.  These functions deal correctly with
//     pathnames from Unix, Macintosh, and Windows (including Microsoft's
//     UNC-style pathnames).
//
// -*- Renamed soko_get_maze_extension() and soko_get_maze_directory() in
//     SokoFile to soko_get_puzzle_extension() and
//     soko_get_puzzle_directory(), respectively.
//
// -*- Added soko_set_puzzle_directory(), soko_set_save_directory(), and
//     soko_set_score_file() to SokoFile in order to complement the existing
//     "get" functions and to centralize control over these settings.
//
// -*- Added soko_get_default_puzzle_directory(),
//     get_default_save_directory(), and soko_get_default_score_file() to
//     SokoFile.  These functions return values appropriate for the
//     corresponding fields on the Preferences panel of each port when the
//     "Defaults" button is pressed.
//
// -*- Renamed soko_save_filename_for_maze_name() and
//     soko_maze_name_for_level() in SokoFile to to
//     soko_save_filename_for_puzzle_name() and soko_puzzle_name_for_level(),
//     respectively.
//
// -*- Added soko_level_for_puzzle_name() to SokoFile.  This function is used
//     by the new "Next Puzzle" menu item and shortcut.
//
// -*- Augmented soko_collapse_path() so that it also knows how to emit
//     $(SokoUser), $(HOME), $(TEMP), and $(TMP), in addition to the existing
//     $(SokoSave).
//
// -*- Added SokoSetting implementation which provides a platform-independent
//     API for accessing user settings and well-known paths, such as
//     $(SokoSave) and $(SokoUser).
//-----------------------------------------------------------------------------
#include "SokoDefs.h"

soko_export char const* soko_get_default_puzzle_directory( cSokoPool );
soko_export char const* soko_get_puzzle_directory( cSokoPool );
soko_export void soko_set_puzzle_directory( cSokoPool, char const* path );

soko_export char const* soko_get_default_save_directory( cSokoPool );
soko_export char const* soko_get_save_directory( cSokoPool );
soko_export void soko_set_save_directory( cSokoPool, char const* path );

soko_export char const* soko_get_factory_score_file( cSokoPool );
soko_export char const* soko_get_default_score_file( cSokoPool );
soko_export char const* soko_get_score_file( cSokoPool );
soko_export void soko_set_score_file( cSokoPool, char const* path );

soko_export char const* soko_collapse_path( cSokoPool, char const* filename );
soko_export char const* soko_expand_path( cSokoPool, char const* filename );

#endif // SokoFile_h
