#ifndef SokoEncode_h
#define SokoEncode_h
//-----------------------------------------------------------------------------
// SokoEncode.h
//
//	Routines for using run length encoding for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy <zarnuk@high-speed-software.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoEncode.h,v 1.3 2001/12/21 21:56:44 sunshine Exp $
// $Log: SokoEncode.h,v $
// Revision 1.3  2001/12/21 21:56:44  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Augmented all input/output logic so that it now deals gracefully with
//     line terminators from all common platforms; Unix (LF), Macintosh (CR),
//     and Windows/DOS (CRLF).
//
//-----------------------------------------------------------------------------
#include <stdio.h>
#include "SokoDefs.h"

soko_export void
soko_run_length_encode_string( FILE*, char const* string, int string_length );
soko_export void
soko_run_length_encode_char( FILE*, char ch, int run_length );

soko_export soko_bool
soko_run_length_decode_string( FILE*, char* buff, int buff_len );
soko_export soko_bool
soko_run_length_decode_char( FILE*, char* ch, int* run_length );

#endif // SokoEncode_h
