#ifndef SokoDefs_h
#define SokoDefs_h
//-----------------------------------------------------------------------------
// SokoDefs.h
//
//	Basic definitions for the core SokoSave library.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoDefs.h,v 1.4 2002/01/29 18:20:47 sunshine Exp $
// $Log: SokoDefs.h,v $
// Revision 1.4  2002/01/29 18:20:47  sunshine
// v17:
// -*- Now recognize these additional file extensions: .xsb, .hsb, .sokohex.
//
// Revision 1.3  2001/12/21 21:55:00  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//-----------------------------------------------------------------------------
#if !defined(soko_export)
#  if defined(__cplusplus)
#    define soko_export extern "C"
#  else
#    define soko_export extern
#  endif
#endif

#if defined(__cplusplus)
#  define SOKO_EXTERN_C_OPEN  extern "C" {
#  define SOKO_EXTERN_C_CLOSE }
#else
#  define SOKO_EXTERN_C_OPEN
#  define SOKO_EXTERN_C_CLOSE
#endif

#if defined(__WIN32__) || defined(WIN32)
#  define SOKO_PLATFORM_WIN32
#elif defined(__APPLE__)
#  define SOKO_PLATFORM_MACINTOSH
#elif defined(__NeXT__)
#  define SOKO_PLATFORM_NEXT
#endif

#if defined(__BORLAND__) || defined(__BORLANDC__)
#  define SOKO_BUILD_ENV_BORLAND
#endif

typedef int soko_bool;
#define soko_true  ((soko_bool)1)
#define soko_false ((soko_bool)0)

typedef enum
    {
    SOKO_ALERT_INFO,
    SOKO_ALERT_WARNING,
    SOKO_ALERT_ERROR
    } SokoAlert;
#define SOKO_ALERT_MAX (SOKO_ALERT_ERROR + 1)

#define SOKO_AUTHOR_MCCARTHY	"Paul McCarthy"
#define SOKO_AUTHOR_SUNSHINE	"Eric Sunshine"
#define SOKO_MAIL_MCCARTHY	"zarnuk@high-speed-software.com"
#define SOKO_MAIL_SUNSHINE	"sunshine@sunshineco.com"
#define SOKO_WEB_PAGE		"www.high-speed-software.com/sokosave"

#define	SOKO_ENV_FACTORY        "SokoSave"
#define SOKO_ENV_USER           "SokoUser"

#define	SOKO_DEF_PUZZLE_DIR     "puzzle" /* Relative to $(SokoSave). */
#define	SOKO_DEF_SAVE_DIR       ""       /* Relative to $(SokoUser). */
#define	SOKO_DEF_FACTORY_SCORES "SCORES" /* Relative to $(SokoSave). */
#define	SOKO_DEF_SCORES         "SCORES" /* Relative to $(SokoUser). */

#define	SOKO_SETTING_PUZZLE_DIR "PuzzleDirectory"
#define	SOKO_SETTING_SAVE_DIR   "SaveDirectory"
#define	SOKO_SETTING_SCORE_FILE "ScoreFile"
#define SOKO_SETTING_AUTO_SAVE  "AutoSave"
#define	SOKO_SETTING_LEVEL      "Level"

#endif // SokoDefs_h
