#ifndef SokoAssert_h
#define SokoAssert_h
//-----------------------------------------------------------------------------
// SokoAssert.h
//
//	Defines SOKO_ASSERT() as a replacement for assert() since the assert()
//	function/macro on some platforms (notably Windows) generates
//	compilation warnings.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoAssert.h,v 1.1 2001/12/21 21:54:02 sunshine Exp $
// $Log: SokoAssert.h,v $
// Revision 1.1  2001/12/21 21:54:02  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
//-----------------------------------------------------------------------------
#include "SokoDefs.h"
#if defined(__cplusplus)
extern "C" {
#endif
#include <assert.h>
#if defined(__cplusplus)
}
#endif

#if defined(NDEBUG)
#define SOKO_ASSERT(X)
#else
#if defined(SOKO_PLATFORM_WIN32) && !defined(SOKO_BUILD_ENV_BORLAND)
#define SOKO_ASSERT(X) {if(!(X)) _assert((void*)#X,(void*)__FILE__,__LINE__);}
#else
#define SOKO_ASSERT assert
#endif // SOKO_PLATFORM_WIN32
#endif // NDEBUG

#endif // SokoAssert_h
