#ifndef SokoURL_h
#define SokoURL_h
//-----------------------------------------------------------------------------
// SokoInfo.h
//
//	Subclass of TLabel which represents a URL.  Clicking on the label
//	opens the associated URL.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL.h,v 1.1 2001/12/21 21:44:37 sunshine Exp $
// $Log: SokoURL.h,v $
// Revision 1.1  2001/12/21 21:44:37  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include <stdctrls.hpp>

class TSokoURL : public TLabel
    {
    typedef TLabel superclass;
private:
    AnsiString url;
    bool url_ok;
    bool mouse_inside;
    bool tracking_mouse;
    void adjust_cursor();
    void adjust_color();
    void __fastcall set_url( AnsiString );
    void __fastcall mouse_enter( Messages::TMessage& );
    void __fastcall mouse_exit( Messages::TMessage& );
    void __fastcall mouse_down( TObject* sender,
	TMouseButton button, TShiftState shift, int x, int y );
    void __fastcall mouse_up( TObject* sender,
	TMouseButton button, TShiftState shift, int x, int y );
protected:
    BEGIN_MESSAGE_MAP
	MESSAGE_HANDLER(CM_MOUSEENTER, TMessage, mouse_enter);
	MESSAGE_HANDLER(CM_MOUSELEAVE, TMessage, mouse_exit);
    END_MESSAGE_MAP(superclass);
public:
    static TSokoURL* subsume( TLabel*& );
    __fastcall TSokoURL( TComponent* owner );
    virtual void __fastcall Assign( TPersistent* source );
    __property AnsiString URL = { read = url, write = set_url };
    };

#endif // SokoURL_h
