//-----------------------------------------------------------------------------
// SokoURL.cpp
//
//	Subclass of TLabel which represents a URL.  Clicking on the label
//	opens the associated URL.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoURL.cpp,v 1.1 2001/12/21 21:44:34 sunshine Exp $
// $Log: SokoURL.cpp,v $
// Revision 1.1  2001/12/21 21:44:34  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include "SokoURL.h"
#include <shellapi.h>

//-----------------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------------
__fastcall TSokoURL::TSokoURL( TComponent* owner ) : superclass(owner),
    url_ok(false), mouse_inside(false), tracking_mouse(false)
    {
    OnMouseDown = mouse_down;
    OnMouseUp = mouse_up;
    adjust_cursor();
    adjust_color();
    }


//-----------------------------------------------------------------------------
// Assign
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::Assign( TPersistent* object )
    {
    TLabel* p = dynamic_cast<TLabel*>(object);
    if (p == 0)
	superclass::Assign( object );
    else
	{
	Align = p->Align;
	Alignment = p->Alignment;
	Anchors = p->Anchors;
	AutoSize = p->AutoSize;
	Caption = p->Caption;
	Color = p->Color;
	Font->Assign( p->Font );
	Height = p->Height;
	Layout = p->Layout;
	Left = p->Left;
	Tag = p->Tag;
	Top = p->Top;
	Transparent = p->Transparent;
	Visible = p->Visible;
	Width = p->Width;
	WordWrap = p->WordWrap;
	adjust_color();
	}
    }


//-----------------------------------------------------------------------------
// subsume
//-----------------------------------------------------------------------------
TSokoURL* TSokoURL::subsume( TLabel*& label )
    {
    TSokoURL* url_label = new TSokoURL( label->Owner );
    url_label->Assign( label );
    url_label->Parent = label->Parent;
    label->Parent = 0;
    delete label;
    label = url_label;
    return url_label;
    }


//-----------------------------------------------------------------------------
// set_url
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::set_url( AnsiString s )
    {
    url = s;
    url_ok = !url.IsEmpty();
    if (!url_ok)
	mouse_inside = tracking_mouse = false;
    adjust_cursor();
    adjust_color();
    }


//-----------------------------------------------------------------------------
// adjust_cursor
//-----------------------------------------------------------------------------
void TSokoURL::adjust_cursor()
    {
    Cursor = (url_ok ? crHandPoint : crDefault);
    }


//-----------------------------------------------------------------------------
// adjust_color
//-----------------------------------------------------------------------------
void TSokoURL::adjust_color()
    {
    TColor c;
    if (!url_ok)
	c = clBlack;
    else if (!mouse_inside)
	c = clPurple;
    else if (tracking_mouse) // && mouse_inside
	c = clRed;
    else // (mouse_inside && !tracking_mouse)
	c = clBlue;
    Font->Color = c;
    }


//-----------------------------------------------------------------------------
// mouse_enter
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::mouse_enter( Messages::TMessage& m )
    {
    if (url_ok)
	{
	mouse_inside = true;
	adjust_color();
	Font->Style = Font->Style << fsUnderline;
	}
    }


//-----------------------------------------------------------------------------
// mouse_exit
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::mouse_exit( Messages::TMessage& m )
    {
    if (url_ok)
	{
	mouse_inside = false;
	adjust_color();
	Font->Style = Font->Style >> fsUnderline;
	}
    }


//-----------------------------------------------------------------------------
// mouse_down
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::mouse_down(
    TObject* sender, TMouseButton button, TShiftState shift, int x, int y )
    {
    if (url_ok)
	{
	tracking_mouse = true;
	adjust_color();
	}
    }


//-----------------------------------------------------------------------------
// mouse_up
//-----------------------------------------------------------------------------
void __fastcall TSokoURL::mouse_up(
    TObject* sender, TMouseButton button, TShiftState shift, int x, int y )
    {
    if (url_ok)
	{
	tracking_mouse = false;
	adjust_color();
	if (mouse_inside)
	    ShellExecute( Parent->Handle, "open", url.c_str(), 0, 0, SW_SHOW );
	}
    }
