#ifndef SokoTrackBar_h
#define SokoTrackBar_h
//-----------------------------------------------------------------------------
// SokoTrackBar.h
//
//	Subclass of TTrackBar which provides an OnEndTracking event.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoTrackBar.h,v 1.1 2001/12/21 21:44:10 sunshine Exp $
// $Log: SokoTrackBar.h,v $
// Revision 1.1  2001/12/21 21:44:10  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include <comctrls.hpp>

class TSokoTrackBar : public TTrackBar
    {
    typedef TTrackBar superclass;
private:
    TNotifyEvent on_end_tracking;
    void __fastcall scrolled( Messages::TMessage& );
protected:
    BEGIN_MESSAGE_MAP
	MESSAGE_HANDLER(CN_HSCROLL, TMessage, scrolled);
	MESSAGE_HANDLER(CN_VSCROLL, TMessage, scrolled);
    END_MESSAGE_MAP(superclass);
public:
    static TSokoTrackBar* subsume( TTrackBar*& );
    __fastcall TSokoTrackBar( TComponent* owner );
    virtual void __fastcall Assign( TPersistent* source );
    __property TNotifyEvent OnEndTracking =
	{ read=on_end_tracking, write=on_end_tracking };
    };

#endif // SokoTrackBar_h
