//-----------------------------------------------------------------------------
// SokoTrackBar.cpp
//
//	Subclass of TTrackBar which provides an OnEndTracking event.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoTrackBar.cpp,v 1.1 2001/12/21 21:44:40 sunshine Exp $
// $Log: SokoTrackBar.cpp,v $
// Revision 1.1  2001/12/21 21:44:40  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include "SokoTrackBar.h"
#include <stdio.h>

//-----------------------------------------------------------------------------
// Contructor
//-----------------------------------------------------------------------------
__fastcall TSokoTrackBar::TSokoTrackBar( TComponent* owner ) :
    superclass(owner), on_end_tracking(0)
    {
    }


//-----------------------------------------------------------------------------
// Assign
//-----------------------------------------------------------------------------
void __fastcall TSokoTrackBar::Assign( TPersistent* object )
    {
    TTrackBar* p = dynamic_cast<TTrackBar*>(object);
    if (p == 0)
	superclass::Assign( object );
    else
	{
	Align = p->Align;
	Anchors = p->Anchors;
	BorderWidth = p->BorderWidth;
	Constraints->Assign( p->Constraints );
	Cursor = p->Cursor;
	Frequency = p->Frequency;
	Height = p->Height;
	Left = p->Left;
	LineSize = p->LineSize;
	Max = p->Max;
	Min = p->Min;
	OnChange = p->OnChange;
	OnEnter = p->OnEnter;
	OnExit = p->OnExit;
	OnKeyDown = p->OnKeyDown;
	OnKeyPress = p->OnKeyPress;
	OnKeyUp = p->OnKeyUp;
	Orientation = p->Orientation;
	PageSize = p->PageSize;
	Position = p->Position;
	SelEnd = p->SelEnd;
	SelStart = p->SelStart;
	SliderVisible = p->SliderVisible;
	Tag = p->Tag;
	ThumbLength = p->ThumbLength;
	TickMarks = p->TickMarks;
	TickStyle = p->TickStyle;
	Top = p->Top;
	Visible = p->Visible;
	Width = p->Width;
	}
    }


//-----------------------------------------------------------------------------
// subsume
//-----------------------------------------------------------------------------
TSokoTrackBar* TSokoTrackBar::subsume( TTrackBar*& bar )
    {
    TSokoTrackBar* soko_bar = new TSokoTrackBar( bar->Owner );
    soko_bar->Assign( bar );
    soko_bar->Parent = bar->Parent;
    bar->Parent = 0;
    delete bar;
    bar = soko_bar;
    return soko_bar;
    }


//-----------------------------------------------------------------------------
// scrolled
//	If the track bar is disabled by the OnEndTracking callback, then we
//	receive a second, erroneous TB_ENDTRACK message.  Therefore, take care
//	to specially guard against this case by checking "Enabled".
//-----------------------------------------------------------------------------
void __fastcall TSokoTrackBar::scrolled( Messages::TMessage& m )
    {
    if (m.WParamLo == TB_ENDTRACK && Enabled && on_end_tracking != 0)
	on_end_tracking( this );
    superclass::Dispatch(&m);
    }
