#ifndef SokoScores_h
#define SokoScores_h
//-----------------------------------------------------------------------------
// SokoScores.h
//
//	High score panel for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoScores.h,v 1.2 2002/01/29 21:27:02 sunshine Exp $
// $Log: SokoScores.h,v $
// Revision 1.2  2002/01/29 21:27:02  sunshine
// v17
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Added "runs" and "focus" scores columns to scores panel and to "New
//     Score" panel.
//
// -*- Fixed a number of aesthetic problems which showed up when using larger
//     control sizes and fonts.  Controls would clobber one another and text
//     would be clipped.  The problems were particularly acute when using
//     "Large Fonts" from the Windows Display/Advanced settings.
//
// -*- SokoScores now adjusts row height of the TStringGrid, if necessary, to
//     account for large fonts.
//
// Revision 1.1  2001-12-21 16:44:22-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//-----------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
#include "SokoForm.h"
class SokoPuzzle;
class SokoScore;
class SokoScoresDelegate;

class TSokoScoresForm : public TSokoForm
{
__published:
    TStringGrid* table;
    void __fastcall form_close( TObject* sender, TCloseAction& action );
    void __fastcall form_create( TObject* sender );
    void __fastcall table_column_moved( TObject* sender, int from, int to );
private:
    SokoScore* scores;
    SokoScoresDelegate* delegate;
    void restore_column_info();
    void save_column_info();
    void set_titles();
    void sort_scores();
    void load_scroll();
    void scroll_row_to_visible( int row );
    void highlight_row( int row );
    void add_score( SokoPuzzle&, int moves, int pushes, int runs, int focus,
	char const* player, char const* notes );
public:
    static void launch();
    static void record_score(
	SokoPuzzle&,
	int moves,
	int pushes,
	int runs,
	int focus,
	char const* player,
	char const* notes );
    __fastcall TSokoScoresForm( TComponent* owner );
    virtual __fastcall ~TSokoScoresForm();
};

extern PACKAGE TSokoScoresForm* SokoScoresForm;

#endif // SokoScores_h
