;;-----------------------------------------------------------------------------
;; SokoSave.iss
;;
;;	InnoSetup installer script for SokoSave.
;;
;; Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
;; All rights reserved.
;;-----------------------------------------------------------------------------
;;-----------------------------------------------------------------------------
;; $Id: SokoSave.iss,v 1.4 2002/05/06 07:20:21 sunshine Exp $
;; $Log: SokoSave.iss,v $
;; Revision 1.4  2002/05/06 07:20:21  sunshine
;; v19
;; -*- Worked around a potential problem where the RCS directories from
;;     "help" "help/image" were being copied into the installer program if
;;     those directories were present.  This is a limitation of InnoSetup, in
;;     which it is not possible to both recurse into subdirectories and
;;     filter out certain entries (such as the RCS directories).  For now, I
;;     removed the recursion from the rule which copies the help files into
;;     the installer program.  This is not a perfect solution, however.
;;
;; Revision 1.3  2002/02/19 08:00:48  sunshine
;; v18
;; -*- Added support for new triangular-style Trioban puzzles.
;;
;; -*- Made the SokoSave.iss setup script more robust.  Now takes advantage
;;     of the "recursesubdirs" flags to ensure that all subdirectories of
;;     `puzzle' and `help' are included in the setup program, instead of
;;     naming each subdirectory manually.
;;
;; Revision 1.2  2002/01/30 07:05:01  sunshine
;; v17
;; -*- The ISS setup script no longer copies README_BINARY.txt into the
;;     output directory.  Having that README file present in the source
;;     package was inconsistent since the other README_BINARY files are not
;;     present.
;;
;; -*- Added new Hexoban puzzles.
;;-----------------------------------------------------------------------------

[Setup]
AppName=SokoSave
AppVerName=SokoSave
AppMutex=SokoSave -- BCB Port
AppPublisher=High Speed Software
AppPublisherURL=http://www.high-speed-software.com/sokosave
AppSupportURL=http://www.high-speed-software.com/sokosave
AppUpdatesURL=http://www.high-speed-software.com/sokosave
ChangesAssociations=yes
DefaultDirName={pf}\SokoSave
DefaultGroupName=SokoSave
DisableStartupPrompt=yes
OutputBaseFilename=soksetup
OutputDir=setup
UninstallDisplayIcon={app}\SokoSave.exe
UninstallFilesDir={app}\receipt

[Tasks]
Name: "desktopicon"; Description: "Create a &desktop icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4
Name: "quicklaunchicon"; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4

[Files]
Source: "SokoSave.exe"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\SCORES"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\HISTORY.txt"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\BUGS.txt"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\TODO.txt"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\FILE_SYNTAX.txt"; DestDir: "{app}"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\puzzle\*.*"; DestDir: "{app}\puzzle"; CopyMode: alwaysoverwrite; Flags: overwritereadonly recursesubdirs
Source: "..\help\*.*"; DestDir: "{app}\help"; CopyMode: alwaysoverwrite; Flags: overwritereadonly
Source: "..\help\images\*.*"; DestDir: "{app}\help\images"; CopyMode: alwaysoverwrite; Flags: overwritereadonly

[Icons]
Name: "{group}\SokoSave"; Filename: "{app}\SokoSave.exe"; Comment: "Launch SokoSave"
Name: "{group}\SokoSave Instructions"; Filename: "{app}\help\SokoHelp.html"; Comment: "View SokoSave Instructions"
Name: "{userdesktop}\SokoSave"; Filename: "{app}\SokoSave.exe"; Comment: "Launch SokoSave"; MinVersion: 4,4; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\SokoSave"; Filename: "{app}\SokoSave.exe"; Comment: "Launch SokoSave"; MinVersion: 4,4; Tasks: quicklaunchicon

[Registry]
Root: HKCU; Subkey: "Software\HighSpeedSoftware"; Flags: dontcreatekey uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\HighSpeedSoftware\SokoSave"; Flags: dontcreatekey uninsdeletekeyifempty
Root: HKCR; Subkey: ".sokomaze"; Flags: dontcreatekey uninsdeletekey
Root: HKCR; Subkey: ".sokosave"; Flags: dontcreatekey uninsdeletekey
Root: HKCR; Subkey: "SokoSave.sokomaze"; Flags: dontcreatekey uninsdeletekey
Root: HKCR; Subkey: "SokoSave.sokosave"; Flags: dontcreatekey uninsdeletekey

[Run]
Filename: "{app}\SokoSave.exe"; Description: "Launch SokoSave"; Flags: nowait postinstall skipifsilent
