//-----------------------------------------------------------------------------
// SokoSave.cpp
//
//	C++Builder boilerplate WinMain() and form registration.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoSave.cpp,v 1.3 2002/02/19 08:02:44 sunshine Exp $
// $Log: SokoSave.cpp,v $
// Revision 1.3  2002/02/19 08:02:44  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
// -*- Moved the BITMAP declarations for the tiles out of SokoBoard.rc and
//     into the new SokoGridSquare.rc, SokoGridHexagon.rc, and
//     SokoGridTriangle.rc.
//
// Revision 1.2  2002-01-29 16:33:36-05  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//
// Revision 1.1  2001-12-21 16:45:55-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//-----------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

USERC("SokoBoard.rc");
USERC("SokoGridHexagon.rc");
USERC("SokoGridSquare.rc");
USERC("SokoGridTriangle.rc");
USERC("SokoInfo.rc");
USERC("SokoSave.rc");
USEFORM("SokoApp.cpp", SokoAppForm);
USEFORM("SokoBoard.cpp", SokoBoardForm);
USEFORM("SokoInfo.cpp", SokoInfoForm);
USEFORM("SokoPref.cpp", SokoPrefForm);
USEFORM("SokoNewScore.cpp", SokoNewScoreForm);
USEFORM("SokoScores.cpp", SokoScoresForm);
USEUNIT("SokoAlerter.cpp");
USEUNIT("SokoDefaults.cpp");
USEUNIT("SokoForm.cpp");
USEUNIT("SokoGrid.cpp");
USEUNIT("SokoGridHexagon.cpp");
USEUNIT("SokoGridSquare.cpp");
USEUNIT("SokoGridTriangle.cpp");
USEUNIT("SokoRendezvous.cpp");
USEUNIT("SokoTrackBar.cpp");
USEUNIT("SokoURL.cpp");
USEUNIT("..\common\SokoEncode.c");
USEUNIT("..\common\SokoFile.c");
USEUNIT("..\common\SokoGeometry.c");
USEUNIT("..\common\SokoPool.c");
USEUNIT("..\common\SokoPuzzle.c");
USEUNIT("..\common\SokoScore.c");
USEUNIT("..\common\SokoSetting.c");
USEUNIT("..\common\SokoUtil.c");

#include "SokoApp.h"
#include "SokoRendezvous.h"
#define SOKO_IDENTIFIERS_NAME
#include "SokoSave.rc"

//----------------------------------------------------------------------------
// WinMain
//----------------------------------------------------------------------------
WINAPI WinMain( HINSTANCE, HINSTANCE, LPSTR, int )
    {
    try
	{
	SokoRendezvous r;
	if (r.rendezvous( "SokoSave -- BCB Port" ))
	    {
	    Application->Initialize();
	    Application->Title = "SokoSave";
	    Application->ShowMainForm = false;
	    Application->Icon->Handle =
		LoadIcon( HInstance, SOKO_ICON_APPLICATION );
	    Application->CreateForm( __classid(TSokoAppForm), &SokoAppForm );
	    ShowWindow( Application->Handle, SW_HIDE );
	    SokoAppForm->set_rendezvous_point(&r);
	    Application->Run();
	    }
	}
    catch (Exception& exception)
	{
	Application->ShowException( &exception );
	}
    return 0;
    }
