#ifndef SokoRendezvous_h
#define SokoRendezvous_h
//-----------------------------------------------------------------------------
// SokoRendezvous.h
//
//	A facility which provides a mechanism for ensuring that only a single
//	instance of a particular application is running at any particular time.
//	Also forwards command-line arguments from other instances of the
//	application to the first running instance.
//
//	Each application should create an instance of this class as the very
//	first task of WinMain().  In general, the instance should be created as
//	a stack-based local variable.  Doing so will ensure that the resources
//	used by this class will be released automatically when the object goes
//	out of scope.
//
//	Immediately after creation, invoke the rendezvous() method.  The
//	argument to rendezvous() is a signature which identifies this
//	application.  Instances trying to rendezvous will look for a running
//	application with this signature.  Control returns from rendezvous()
//	upon one of the following conditions:
//
//	- If this is the first running instance of the application.
//	- If this is not the first running instance, but the first running
//	  instance is ready to listen for notifications from other instances,
//	  and has accepted the command-line arguments from this instance.
//	- An error occurs while trying to rendezvous.
//
//	rendezvous() returns `true' if this is the first running instance of
//	the application; otherwise it returns `false'.
//
//	The first instance must then invoke listen() to register the action
//	which will be invoked when command-line arguments are received from
//	other instances of the application.  Other instances of the application
//	will only be able to send command-line arguments to the first instance
//	after the first instance has registered its callback action.  In fact,
//	other instances will enter a wait-state until the first instance is
//	ready to receive command-line arguments (or until the first instance
//	terminates).
//
//	Running instances of the application, other than the first, should
//	terminate themselves immediately upon receipt of `false' from
//	rendezvous().  Typically, this is accomplished by falling off the end
//	of the WinMain() function.  Command-line arguments will already have
//	been sent to the first instance by the time rendezvous() returns to the
//	caller.
//
//	The first running instance will receive command-line arguments from the
//	other applications as a block of null-terminated strings.  The list of
//	arguments, itself, is also terminated by a null byte.  If no arguments
//	were given on the command-line of the other instance, then the string
//	block will consist of a single terminating null byte.  An application
//	can retrieve the string arguments in the following fashion:
//
//	char const* args = ...; /* incoming argument block */
//	for ( ; *args != '\0'; args += strlen(args) + 1)
//	    handle_arg(args);
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoRendezvous.h,v 1.1 2001/12/21 21:46:25 sunshine Exp $
// $Log: SokoRendezvous.h,v $
// Revision 1.1  2001/12/21 21:46:25  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include <vcl.h>

class SokoRendezvous
    {
public:
    typedef void __fastcall (__closure *Listener)( char const* args );
private:
    Listener listener;
    HANDLE mutex;
    HWND window;
    static void send_command_line( HWND );
    static LRESULT CALLBACK window_proc( HWND, UINT msg, WPARAM, LPARAM );
public:
    SokoRendezvous();
    ~SokoRendezvous();
    bool rendezvous( char const* signature );
    void listen( Listener );
    };

#endif // SokoRendezvous_h
