#ifndef SokoPref_h
#define SokoPref_h
//-----------------------------------------------------------------------------
// SokoPref.h
//
//	User preference management form for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPref.h,v 1.2 2002/01/29 21:29:14 sunshine Exp $
// $Log: SokoPref.h,v $
// Revision 1.2  2002/01/29 21:29:14  sunshine
// v17
// -*- Fixed a number of aesthetic problems which showed up when using larger
//     control sizes and fonts.  Controls would clobber one another and text
//     would be clipped.  The problems were particularly acute when using
//     "Large Fonts" from the Windows Display/Advanced settings.
//
// -*- Added `user_resizing' property to SokoForm which is `true' during a
//     user- initiated window resize operation.  This provides clients with
//     the capability to make constraint decisions based upon the agent which
//     is resizing a window, rather than always applying constraints,
//     regardless of whether resizing was initiated by the user or by Windows
//     (for instance, if font metrics had changed).
//
// -*- SokoPref controls no longer become all jumbled together if user has
//     selected large fonts.  Also, added a TPanel behind all of the controls
//     to keep them from falling off bottom of window when user changes
//     Window display scheme.
//
// Revision 1.1  2001-12-21 16:46:15-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//-----------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "SokoForm.h"
class SokoSetting;

class TSokoPrefForm : public TSokoForm
    {
__published:
    TPanel* control_panel;
    TBevel* shortcut_bevel;
    TButton* cancel_button;
    TButton* defaults_button;
    TButton* set_button;
    TGroupBox* save_box;
    TEdit* save_path_field;
    TCheckBox* auto_save_switch;
    TGroupBox* score_box;
    TEdit* score_path_field;
    TGroupBox* puzzle_box;
    TEdit* puzzle_path_field;
    TGroupBox* level_box;
    TEdit* level_field;
    TCheckBox* toolbar_switch;
    void __fastcall form_create( TObject* sender );
    void __fastcall form_close( TObject* sender, TCloseAction& action );
    void __fastcall form_can_resize(TObject* sender, int& w, int& h, bool& ok);
    void __fastcall set_button_click( TObject* sender );
    void __fastcall cancel_button_click( TObject* sender );
    void __fastcall defaults_button_click( TObject* sender );
    void __fastcall toolbar_switch_click( TObject* sender );
    void __fastcall setting_changed( TObject* sender );
    void __fastcall form_resize( TObject* sender );
private:
    SokoSetting* setting;
    bool dirty;
    bool toolbar_switch_toggled;
    int min_width;
    int current_width;
    void set_dirty( bool );
    void load_defaults();
    void load_settings();
    void save_settings();
public:
    static void launch();
    static bool should_show_toolbar();
    static int get_next_level();
    static void set_next_level( int );
    __fastcall TSokoPrefForm( TComponent* owner );
    virtual __fastcall ~TSokoPrefForm();
};

extern PACKAGE TSokoPrefForm* SokoPrefForm;

#endif // SokoPref_h
