//-----------------------------------------------------------------------------
// SokoInfo.cpp
//
//	Application information panel for SokoSave.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.cpp,v 1.1 2001/12/21 21:46:55 sunshine Exp $
// $Log: SokoInfo.cpp,v $
// Revision 1.1  2001/12/21 21:46:55  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SokoInfo.h"
#include "SokoDefs.h"
#include "SokoBuild.h"
#include "SokoRelease.h"
#include "SokoURL.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TSokoInfoForm* SokoInfoForm = 0;

#define SOKO_APP_ICON_NAME "SokoSave"

//-----------------------------------------------------------------------------
// launch
//-----------------------------------------------------------------------------
void TSokoInfoForm::launch()
    {
    if (SokoInfoForm == 0)
	SokoInfoForm = new TSokoInfoForm( Application );
    if (SokoInfoForm->WindowState == wsMinimized)
	ShowWindow( SokoInfoForm->Handle, SW_RESTORE );
    SokoInfoForm->Show();
    }


//-----------------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------------
__fastcall TSokoInfoForm::TSokoInfoForm( TComponent* owner ) : TSokoForm(owner)
    {
    app_icon->Picture->Bitmap->LoadFromResourceName(
	(int)HInstance, SOKO_APP_ICON_NAME );
    }


//-----------------------------------------------------------------------------
// form_create
//-----------------------------------------------------------------------------
void __fastcall TSokoInfoForm::form_create( TObject* sender )
    {
    AnsiString lt('<'), gt('>');
    TSokoURL::subsume( mail_sunshine )->URL = "mailto:" SOKO_MAIL_SUNSHINE;
    TSokoURL::subsume( mail_mccarthy )->URL = "mailto:" SOKO_MAIL_MCCARTHY;
    TSokoURL::subsume( web_page )->URL = "http://" SOKO_WEB_PAGE "/";
    mail_sunshine->Caption = lt + SOKO_MAIL_SUNSHINE + gt;
    mail_mccarthy->Caption = lt + SOKO_MAIL_MCCARTHY + gt;
    web_page->Caption = SOKO_WEB_PAGE;
    author_sunshine->Caption = SOKO_AUTHOR_SUNSHINE;
    author_mccarthy->Caption = SOKO_AUTHOR_MCCARTHY;
    release_field->Caption = release_field->Caption + " " SOKO_RELEASE;
    build_field->Caption = build_field->Caption + " " SOKO_BUILD;
    }


//-----------------------------------------------------------------------------
// form_close
//-----------------------------------------------------------------------------
void __fastcall TSokoInfoForm::form_close(TObject* sender,TCloseAction& action)
    {
    action = caHide;        
    }
