#ifndef SokoGridTriangle_h
#define SokoGridTriangle_h
//-----------------------------------------------------------------------------
// SokoGridTriangle.h
//
//	A triangular-celled grid for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGridTriangle.h,v 1.2 2002/05/06 05:49:19 sunshine Exp $
// $Log: SokoGridTriangle.h,v $
// Revision 1.2  2002/05/06 05:49:19  sunshine
// v19
// -*- Fixed v17 Win9x problem where animation of Hexoban and Trioban puzzles
//     involved unsightly "flashing" which resulted from Windows first
//     painting the on-screen hexagonal and triangular tiles black before
//     blitting in the actual tile.  To work around the problem,
//     SokoGridHexagon and SokoGridTriangle now maintain a backing-store in
//     which the puzzle image is rendered.  When the on-screen image needs to
//     be repainted, only non-transparent rectangles are blitted to the
//     screen.  This patch cuts animation speed effectively in half for
//     Hexoban and Trioban puzzles, but the visual quality of the animation
//     is much improved.  This problem did not affect WinNT or Win2000.
//
// Revision 1.1  2002/02/19 07:57:22  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//-----------------------------------------------------------------------------
#include "SokoGrid.h"

class TSokoGridTriangle : public TSokoGrid
    {
    typedef TSokoGrid superclass;
private:
    Graphics::TBitmap* cache;
    void create_cache();
    void refresh_cache_cell( int row, int col, SokoCellType );
public:
    __fastcall TSokoGridTriangle( TComponent*, SokoPuzzle* );
    virtual __fastcall ~TSokoGridTriangle();
    virtual void __fastcall Paint();
    virtual void draw_cell( int row, int col, SokoCellType );
    virtual bool mouse_to_cell( int x, int y, int& row, int& col );
    virtual void note_color_change();
    };

#endif // SokoGridTriangle_h
