#ifndef SokoGridSquare_h
#define SokoGridSquare_h
//-----------------------------------------------------------------------------
// SokoGridSquare.h
//
//	A square-celled grid for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGridSquare.h,v 1.1 2002/01/29 22:13:36 sunshine Exp $
// $Log: SokoGridSquare.h,v $
// Revision 1.1  2002/01/29 22:13:36  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//
//-----------------------------------------------------------------------------
#include "SokoGrid.h"

class TSokoGridSquare : public TSokoGrid
    {
    typedef TSokoGrid superclass;
public:
    __fastcall TSokoGridSquare( TComponent*, SokoPuzzle* );
    virtual void __fastcall Paint();
    virtual void draw_cell( int row, int col, SokoCellType );
    virtual bool mouse_to_cell( int x, int y, int& row, int& col );
    };

#endif // SokoGridSquare_h
