#ifndef SokoGridHexagon_h
#define SokoGridHexagon_h
//-----------------------------------------------------------------------------
// SokoGridHexagon.h
//
//	A hexagonal-celled grid for SokoSave.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGridHexagon.h,v 1.3 2002/05/06 05:49:23 sunshine Exp $
// $Log: SokoGridHexagon.h,v $
// Revision 1.3  2002/05/06 05:49:23  sunshine
// v19
// -*- Fixed v17 Win9x problem where animation of Hexoban and Trioban puzzles
//     involved unsightly "flashing" which resulted from Windows first
//     painting the on-screen hexagonal and triangular tiles black before
//     blitting in the actual tile.  To work around the problem,
//     SokoGridHexagon and SokoGridTriangle now maintain a backing-store in
//     which the puzzle image is rendered.  When the on-screen image needs to
//     be repainted, only non-transparent rectangles are blitted to the
//     screen.  This patch cuts animation speed effectively in half for
//     Hexoban and Trioban puzzles, but the visual quality of the animation
//     is much improved.  This problem did not affect WinNT or Win2000.
//
// Revision 1.2  2002/02/19 07:57:33  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Consolidated all of the geometry-related utility code into the new
//     SokoGeometry facility.  This mechanism provides hit-testing and
//     coverage-testing facilities for square-, hexagonal-, and
//     triangular-tiled grids.  All high-level GUI code now utilizes these
//     facilities rather than relying upon their own copy/paste
//     implementations.
//
// Revision 1.1  2002-01-29 17:13:42-05  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#include "SokoGrid.h"

class TSokoGridHexagon : public TSokoGrid
    {
    typedef TSokoGrid superclass;
private:
    Graphics::TBitmap* cache;
    void create_cache();
    void refresh_cache_cell( int row, int col, SokoCellType );
public:
    __fastcall TSokoGridHexagon( TComponent*, SokoPuzzle* );
    virtual __fastcall ~TSokoGridHexagon();
    virtual void __fastcall Paint();
    virtual void draw_cell( int row, int col, SokoCellType );
    virtual bool mouse_to_cell( int x, int y, int& row, int& col );
    virtual void note_color_change();
    };

#endif // SokoGridHexagon_h
