#ifndef SokoGrid_h
#define SokoGrid_h
//-----------------------------------------------------------------------------
// SokoGrid.h
//
//	Base class for visual grid objects which display puzzle board.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGrid.h,v 1.2 2002/05/06 05:49:26 sunshine Exp $
// $Log: SokoGrid.h,v $
// Revision 1.2  2002/05/06 05:49:26  sunshine
// v19
// -*- Fixed v17 Win9x problem where animation of Hexoban and Trioban puzzles
//     involved unsightly "flashing" which resulted from Windows first
//     painting the on-screen hexagonal and triangular tiles black before
//     blitting in the actual tile.  To work around the problem,
//     SokoGridHexagon and SokoGridTriangle now maintain a backing-store in
//     which the puzzle image is rendered.  When the on-screen image needs to
//     be repainted, only non-transparent rectangles are blitted to the
//     screen.  This patch cuts animation speed effectively in half for
//     Hexoban and Trioban puzzles, but the visual quality of the animation
//     is much improved.  This problem did not affect WinNT or Win2000.
//
// Revision 1.1  2002/01/29 22:13:49  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#include <controls.hpp>
#include "SokoPuzzle.h"

class TSokoGrid : public TGraphicControl
    {
    typedef TGraphicControl superclass;
protected:
    SokoPuzzle* puzzle;
    int rows;
    int cols;
__published:
    __property OnMouseDown;
    __property OnMouseMove;
    __property OnMouseUp;
public:
    __fastcall TSokoGrid( TComponent*, SokoPuzzle* );
    virtual void draw_cell( int row, int col, SokoCellType ) = 0;
    virtual bool mouse_to_cell( int x, int y, int& row, int& col ) = 0;
    virtual void note_color_change();
    };

#endif // SokoGrid_h
