//-----------------------------------------------------------------------------
// SokoGrid.cpp
//
//	Base class for visual grid objects which display puzzle board.
//
// Copyright (c), 2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoGrid.cpp,v 1.2 2002/05/06 05:49:15 sunshine Exp $
// $Log: SokoGrid.cpp,v $
// Revision 1.2  2002/05/06 05:49:15  sunshine
// v19
// -*- Fixed v17 Win9x problem where animation of Hexoban and Trioban puzzles
//     involved unsightly "flashing" which resulted from Windows first
//     painting the on-screen hexagonal and triangular tiles black before
//     blitting in the actual tile.  To work around the problem,
//     SokoGridHexagon and SokoGridTriangle now maintain a backing-store in
//     which the puzzle image is rendered.  When the on-screen image needs to
//     be repainted, only non-transparent rectangles are blitted to the
//     screen.  This patch cuts animation speed effectively in half for
//     Hexoban and Trioban puzzles, but the visual quality of the animation
//     is much improved.  This problem did not affect WinNT or Win2000.
//
// Revision 1.1  2002/01/29 22:13:51  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//-----------------------------------------------------------------------------
#include "SokoPool.h"
#include "SokoGrid.h"
#include "SokoAssert.h"

//-----------------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------------
__fastcall TSokoGrid::TSokoGrid( TComponent* owner, SokoPuzzle* p ) :
    superclass(owner), puzzle(p)
    {
    rows = puzzle->row_count();
    cols = puzzle->col_count();

    TAnchors anchors;
    Anchors = anchors;
    TControlStyle style;
    style << csCaptureMouse << csOpaque;
    ControlStyle = style;
    }


//-----------------------------------------------------------------------------
// note_color_change
//-----------------------------------------------------------------------------
void TSokoGrid::note_color_change()
    {
    }
