#ifndef SokoForm_h
#define SokoForm_h
//-----------------------------------------------------------------------------
// SokoForm.h
//
//	Base class of all forms.  Defines behavior common to all forms in
//	SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoForm.h,v 1.2 2002/01/29 21:28:01 sunshine Exp $
// $Log: SokoForm.h,v $
// Revision 1.2  2002/01/29 21:28:01  sunshine
// v17
// -*- Fixed a number of aesthetic problems which showed up when using larger
//     control sizes and fonts.  Controls would clobber one another and text
//     would be clipped.  The problems were particularly acute when using
//     "Large Fonts" from the Windows Display/Advanced settings.
//
// -*- Added `user_resizing' property to SokoForm which is `true' during a
//     user- initiated window resize operation.  This provides clients with
//     the capability to make constraint decisions based upon the agent which
//     is resizing a window, rather than always applying constraints,
//     regardless of whether resizing was initiated by the user or by Windows
//     (for instance, if font metrics had changed).
//
// Revision 1.1  2001-12-21 16:46:52-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//-----------------------------------------------------------------------------
#include <forms.hpp>
#include <menus.hpp>

class TSokoForm : public TForm
    {
    typedef TForm superclass;
private:
    bool cascaded;
    bool f_should_cascade;
    bool f_can_publish;
    bool f_user_resizing;
    TMenuItem* f_window_menu;
    void set_can_publish( bool );
    AnsiString get_caption();
    void set_caption( AnsiString );
    void set_window_menu( TMenuItem* );
    void __fastcall handle_shortcut( Messages::TWMKey&, bool& handled );
    void wm_enter_sizemove( Messages::TMessage& );
    void wm_exit_sizemove( Messages::TMessage& );
    static void register_window( TMenuItem*, TForm* );
    static void register_window( TForm* );
    static void deregister_window( TForm* );
protected:
    virtual void __fastcall CreateParams( TCreateParams& p );
    DYNAMIC void __fastcall DoShow();
    DYNAMIC void __fastcall DoHide();
    BEGIN_MESSAGE_MAP
	MESSAGE_HANDLER(WM_ENTERSIZEMOVE, TMessage, wm_enter_sizemove);
	MESSAGE_HANDLER(WM_EXITSIZEMOVE,  TMessage, wm_exit_sizemove);
    END_MESSAGE_MAP(superclass);
public:
    static void cascade_all();
    static void cascade_window( TForm* );
    __fastcall TSokoForm( TComponent* );
    __property bool should_cascade =
	{ read=f_should_cascade, write=f_should_cascade };
    __property bool can_publish =
	{ read=f_can_publish, write=set_can_publish };
    __property AnsiString Caption = { read=get_caption, write=set_caption };
    __property bool user_resizing = { read=f_user_resizing };
    __property TMenuItem* window_menu =
	{ read=f_window_menu, write=set_window_menu };
    };

#endif // SokoForm_h
